/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import oracle.eclipse.tools.common.util.StringEncrypter;
import oracle.eclipse.tools.weblogic.WebLogicServerUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicWebModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.WebLogicDescriptorFactory;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.CredentialInfo;
import oracle.eclipse.tools.weblogic.server.IServerModuleHelper;
import oracle.eclipse.tools.weblogic.server.IValidatable;
import oracle.eclipse.tools.weblogic.server.IWeblogicServer;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerWorkingCopy;
import oracle.eclipse.tools.weblogic.server.ServerInfo;
import oracle.eclipse.tools.weblogic.server.internal.AbstractWeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.CredentialHelper;
import oracle.eclipse.tools.weblogic.server.internal.Paths;
import oracle.eclipse.tools.weblogic.server.internal.ServerConfiguration;
import oracle.eclipse.tools.weblogic.server.internal.util.FacetUtil;
import oracle.eclipse.tools.weblogic.server.properties.KeystoreType;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.IEARModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.application.Module;
import org.eclipse.jst.javaee.application.Web;
import org.eclipse.jst.server.core.internal.J2EEUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.internal.DeletedModule;
import org.eclipse.wst.server.core.internal.IMonitoredServerPort;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerMonitorManager;
import org.eclipse.wst.server.core.model.IURLProvider;

public class WeblogicServer
extends AbstractWeblogicServer
implements IWeblogicServer,
IWeblogicServerWorkingCopy,
IValidatable,
IURLProvider {
    public static final String ATTR_WEBLOGIC_DOMAIN_PATH = "weblogic_domain_path";
    private static final String ATTR_WEBLOGIC_USE_CONFIG_XML = "weblogic_use_config_xml";
    private static final String ATTR_WEBLOGIC_USE_BOOTPROP = "weblogic_use_bootprop";
    public static final String ATTR_WEBLOGIC_USERNAME = "weblogic_username";
    public static final String ATTR_WEBLOGIC_PASSWORD = "weblogic_password";
    private static final String ATTR_WEBLOGIC_IS_REMOTE = "weblogic_is_remote";
    private static final String ATTR_WEBLOGIC_IS_TUNNELING = "weblogic_is_tunneling";
    public static final String ATTR_WEBLOGIC_HOSTNAME = "weblogic_host_name";
    public static final String PROP_HOSTNAME = "hostname";
    public static final String ATTR_WEBLOGIC_PORT = "weblogic_port";
    public static final String ATTR_WEBLOGIC_HTTPS_PORT = "weblogic_https_port";
    public static final String ATTR_WEBLOGIC_USE_SSL_PORT = "weblogic_use_ssl";
    public static final String ATTR_WEBLOGIC_DEBUG_PORT = "weblogic_debug_port";
    public static final String ATTR_IGNORED_WARNINGS = "user_ignored_warning";
    private static final String SERVER_ATTR_RUNTIME_ID = "runtime-id";
    private static final boolean DEFAULT_USE_BOOTPROP_FLAG = true;
    private static final boolean DEFAULT_USE_CONFIG_XML_FLAG = true;
    private static final String DEFAULT_USERNAME = "weblogic";
    private static final String DEFAULT_PASSWORD = "welcome1";
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final int DEFAULT_PORT = 7001;
    public static final int DEFAULT_DEBUG_PORT = 8453;
    public static final int DEFAULT_DEPLOYMENT_TIMEOUT = 5;
    private static final String PORT_CONTENT_TYPE_HTML = "text/html";
    private static final ServerPort[] EMPTY_PORTS = new ServerPort[0];
    private transient ServerConfiguration config;
    private transient CredentialHelper cred;
    InetAddress localhost = null;
    public static final String WLS92_SERVER_TYPE_ID = "com.bea.wlw.server92";
    private static ArrayList<IServerModuleHelper> serverModuleHelpers = null;
    private static String SERVER_MODULE_HELPER_EXT_POINT = "oracle.eclipse.tools.weblogic.serverModuleHelper";

    public void initialize() {
        IServer server = this.getServer();
        if (!server.isWorkingCopy()) {
            return;
        }
        IServerWorkingCopy wc = (IServerWorkingCopy)server;
        wc.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propKey = evt.getPropertyName();
                if (!WeblogicServer.SERVER_ATTR_RUNTIME_ID.equals(propKey)) {
                    return;
                }
                WeblogicServer.this.updateRuntime();
            }
        });
        try {
            this.localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {}
    }

    public void dispose() {
        super.dispose();
    }

    public void setDefaults(IProgressMonitor monitor) {
        this.setBootPropUsed(true);
        this.setConfigFileUsed(true);
        this.setUsername(DEFAULT_USERNAME);
        this.setPort(7001);
        this.setDomainPath(null);
        this.setRemote(false);
        this.setHostname(DEFAULT_HOSTNAME);
    }

    public void saveConfiguration(IProgressMonitor monitor) throws CoreException {
        super.saveConfiguration(monitor);
    }

    private void updateRuntime() {
    }

    private IPath guessUserProjectPath(IPath wlHome) {
        IPath userProjPath = wlHome;
        if (userProjPath != null && !userProjPath.isEmpty()) {
            userProjPath = userProjPath.removeLastSegments(1);
            userProjPath = userProjPath.append("user_projects");
            userProjPath = userProjPath.append("domains");
        } else {
            userProjPath = new Path(System.getProperty("value.win.newdomain.base.0"));
        }
        int suf = 1000;
        while (suf >= 0) {
            IPath domainPath = userProjPath.append("mydomain" + suf);
            if (WeblogicServer.validateDomainPath(domainPath).isOK()) {
                return domainPath;
            }
            --suf;
        }
        if (WeblogicServer.validateDomainPath(userProjPath.append("mydomain")).isOK()) {
            return userProjPath.append("mydomain");
        }
        return Path.EMPTY;
    }

    public ServerPort[] getServerPorts() {
        ServerInfo info = this.getServerInfo();
        if (info == null) {
            return EMPTY_PORTS;
        }
        if (this.isUseSSLPort()) {
            return new ServerPort[]{new ServerPort("https", "https", this.getHttpsPort(), "https", new String[]{PORT_CONTENT_TYPE_HTML}, false)};
        }
        return new ServerPort[]{new ServerPort("http", "http", info.getPortNumber(), "http", new String[]{PORT_CONTENT_TYPE_HTML}, false)};
    }

    @Override
    public IStatus canSupportModule(IModule module) {
        IStatus ret = super.canSupportModule(module);
        if (!ret.isOK()) {
            return ret;
        }
        try {
            ServerConfiguration config = this.getServerConfiguration();
            if (config != null) {
                File domainPath = null;
                if (config.getDomainPath() != null) {
                    domainPath = config.getDomainPath().toFile();
                }
                ArrayList<IServerModuleHelper> helpers = WeblogicServer.getServerModuleHelper();
                for (IServerModuleHelper helper : helpers) {
                    IStatus status = helper.canSupportModule(this.getServer(), domainPath, module);
                    if (status == Status.OK_STATUS) continue;
                    return status;
                }
            }
        }
        catch (CoreException coreException) {}
        return Status.OK_STATUS;
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
        this.notifyModuleChanges(add, remove);
    }

    private void notifyModuleChanges(IModule[] add, IModule[] remove) {
        Server server = (Server)this.getServer();
        if (add != null && add.length > 0) {
            server.setModuleState(add, -1);
        }
        if (remove != null && remove.length > 0) {
            server.setModuleState(remove, -1);
        }
    }

    public URL getModuleRootURL(IModule module) {
        try {
            ServerInfo info = this.getServerInfo();
            String path = this.getModuleRootPath(module);
            int port = 7001;
            if (info != null) {
                int wlsPort = this.isUseSSLPort() ? this.getHttpsPort() : info.getPortNumber();
                port = this.getMonitorPort(wlsPort);
                String hostName = info.getHostName();
                hostName = hostName.length() == 0 ? this.getServer().getHost() : hostName;
                String protocol = this.isUseSSLPort() ? "https" : "http";
                return new URL(protocol, hostName, port, path);
            }
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public String getModuleRootPath(IModule module, IModule parent) {
        String context = this.getAppWebContextRoot(parent, module);
        if (context != null && context.length() > 0) {
            context = WeblogicServer.encode(context);
            return "/" + context;
        }
        return "/";
    }

    public String getModuleRootPath(IModule module) {
        IModule[] root;
        if (module == null || module.getProject() == null) {
            return "/";
        }
        if (FacetUtil.hasWebFacet(module) && (root = this.getRootModulesOnThisServer(module)) != null && root.length >= 1) {
            String context = null;
            if (FacetUtil.hasEarFacet(root[0])) {
                return this.getModuleRootPath(module, root[0]);
            }
            if (FacetUtil.hasWebFacet(root[0]) && FacetUtil.hasWebLogicWebFacet(root[0]) && (context = this.getWeblogicContextRoot(module)) != null && context.length() > 0) {
                context = WeblogicServer.encode(context);
            }
            if (context != null) {
                return "/" + context;
            }
        }
        return "/" + J2EEProjectUtilities.getServerContextRoot((IProject)module.getProject());
    }

    private static String encode(String context) {
        if (context.indexOf("\\") < 0) {
            return context;
        }
        StringBuffer buffer = new StringBuffer(context);
        int i = buffer.indexOf("\\");
        while (i >= 0) {
            buffer.replace(i, i + 1, "%5C");
            i = buffer.indexOf("\\", i + 2);
        }
        return buffer.toString();
    }

    private String getWeblogicContextRoot(IModule module) {
        IWebLogicWebModuleDescriptor descriptor = WebLogicDescriptorFactory.getWebDescriptor(module.getProject());
        try {
            if (descriptor == null) {
                String msg = CorePlugin.getString("errorWebContentRootMapping", module.getName());
                CorePlugin.getLevelLog().log(CorePlugin.createErrorStatus(msg));
                return null;
            }
            String contextRoot = descriptor.getContextRoot().text(false);
            if (contextRoot == null) {
                return null;
            }
            String string = contextRoot;
            return string;
        }
        finally {
            if (descriptor != null) {
                descriptor.dispose();
            }
        }
    }

    private String getAppWebContextRoot(IModule root, IModule module) {
        if (module instanceof DeletedModule || root instanceof DeletedModule) {
            return null;
        }
        if (module.getName().startsWith("lib/")) {
            IProject earProject = root.getProject();
            IVirtualComponent c = ComponentCore.createComponent((IProject)earProject);
            IVirtualReference[] iVirtualReferenceArray = c.getReferences();
            int n = iVirtualReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVirtualReference ref = iVirtualReferenceArray[n2];
                IVirtualComponent comp = ref.getReferencedComponent();
                if (comp instanceof J2EEModuleVirtualArchiveComponent) {
                    J2EEModuleVirtualArchiveComponent archive = (J2EEModuleVirtualArchiveComponent)comp;
                    String aName = archive.getName();
                    if (module.getName().endsWith(aName)) {
                        return archive.getDeploymentPath().toPortableString();
                    }
                }
                ++n2;
            }
        }
        String context = null;
        try {
            IProject earProject = root.getProject();
            IEARModelProvider earModel = (IEARModelProvider)ModelProviderManager.getModelProvider((IProject)earProject);
            IVirtualFile appXmlFile = ComponentCore.createFile((IProject)earProject, (IPath)new Path("META-INF/application.xml"));
            IVirtualComponent c = ComponentCore.createComponent((IProject)module.getProject());
            String uri = earModel.getModuleURI(c);
            Object model = earModel.getModelObject();
            if (J2EEProjectUtilities.isJEEProject((IProject)earProject)) {
                if (appXmlFile.exists()) {
                    if (model instanceof org.eclipse.jst.javaee.application.Application) {
                        org.eclipse.jst.javaee.application.Application ee5App = (org.eclipse.jst.javaee.application.Application)model;
                        Module ee5Module = ee5App.getFirstModule(uri);
                        if (ee5Module == null) {
                            String msg = CorePlugin.getString("errorAppWebContentRootMapping", module.getName());
                            CorePlugin.getLevelLog().log(CorePlugin.createErrorStatus(msg));
                        } else {
                            Web ee5Web = ee5Module.getWeb();
                            if (ee5Web == null) {
                                String msg = CorePlugin.getString("errorAppWebContentRootMapping", module.getName());
                                CorePlugin.getLevelLog().log(CorePlugin.createErrorStatus(msg));
                            } else {
                                String contextRoot = ee5Web.getContextRoot();
                                context = contextRoot == null ? "" : contextRoot;
                            }
                        }
                    } else {
                        context = J2EEProjectUtilities.getServerContextRoot((IProject)module.getProject());
                    }
                } else {
                    context = J2EEProjectUtilities.getServerContextRoot((IProject)module.getProject());
                }
            } else if (!appXmlFile.exists()) {
                String msg = CorePlugin.getString("errorApplicationXML", module.getName());
                CorePlugin.getLevelLog().log(CorePlugin.createErrorStatus(msg));
            } else if (model instanceof Application) {
                Application ee14App = (Application)model;
                org.eclipse.jst.j2ee.application.Module ee14Module = ee14App.getFirstModule(uri);
                if (ee14Module == null) {
                    String msg = CorePlugin.getString("errorAppWebContentRootMapping", module.getName());
                    CorePlugin.getLevelLog().log(CorePlugin.createErrorStatus(msg));
                } else if (!(ee14Module instanceof WebModule)) {
                    String msg = CorePlugin.getString("errorAppWebContentRootMapping", module.getName());
                    CorePlugin.getLevelLog().log(CorePlugin.createErrorStatus(msg));
                } else {
                    String contextRoot = ((WebModule)ee14Module).getContextRoot();
                    context = contextRoot == null ? "" : contextRoot;
                }
            }
        }
        catch (Exception exception) {
            String msg = CorePlugin.getString("errorAppWebContentRootMapping", module.getName());
            CorePlugin.getLevelLog().log(CorePlugin.createErrorStatus(msg));
        }
        return context;
    }

    private int getMonitorPort(int configedPort) {
        ServerMonitorManager manager = ServerMonitorManager.getInstance();
        IMonitoredServerPort[] iMonitoredServerPortArray = manager.getMonitoredPorts(this.getServer());
        int n = iMonitoredServerPortArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMonitoredServerPort port = iMonitoredServerPortArray[n2];
            if (port.getServerPort().getPort() == configedPort) {
                return port.getMonitorPort();
            }
            ++n2;
        }
        return configedPort;
    }

    public IModule[] getRootModulesOnThisServer(IModule module) {
        try {
            IFacetedProject facetProject = ProjectFacetsManager.create((IProject)module.getProject());
            if (facetProject.hasProjectFacet(FacetUtil.FACET_JST_EAR)) {
                return new IModule[]{module};
            }
            IModule[] ear = J2EEUtil.getEnterpriseApplications((IModule)module, null);
            if (ear != null && ear.length > 0) {
                ArrayList<IModule> ret = new ArrayList<IModule>();
                IModule[] allModules = this.getServer().getModules();
                int i = 0;
                while (i < ear.length) {
                    int j = 0;
                    while (j < allModules.length) {
                        if (allModules[j] == ear[i]) {
                            ret.add(ear[i]);
                        }
                        ++j;
                    }
                    ++i;
                }
                return ret.toArray(new IModule[ret.size()]);
            }
            return new IModule[]{module};
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    @Override
    public IPath getDomainPath() {
        String domain = this.getAttribute(ATTR_WEBLOGIC_DOMAIN_PATH, null);
        if (domain != null) {
            return new Path(domain);
        }
        return null;
    }

    @Override
    public void setDomainPath(IPath path) {
        String domain = path == null ? null : path.toOSString();
        this.setAttribute(ATTR_WEBLOGIC_DOMAIN_PATH, domain);
    }

    public IPath getRawDomainPath() {
        String domain = this.getAttribute(ATTR_WEBLOGIC_DOMAIN_PATH, null);
        if (domain != null && domain.length() != 0) {
            return new Path(domain);
        }
        return Path.EMPTY;
    }

    @Override
    public boolean isBootPropUsed() {
        return this.getAttribute(ATTR_WEBLOGIC_USE_BOOTPROP, true);
    }

    @Override
    public void setBootPropUsed(boolean use) {
        this.setAttribute(ATTR_WEBLOGIC_USE_BOOTPROP, use);
    }

    @Override
    public boolean isRemote() {
        return this.getAttribute(ATTR_WEBLOGIC_IS_REMOTE, false);
    }

    public boolean isTunneling() {
        return this.getAttribute(ATTR_WEBLOGIC_IS_TUNNELING, false);
    }

    public boolean isSplitSourceDeployment() {
        return this.getAttribute("RUN_WEB_MODULE_FROM_WORKSPACE", true);
    }

    public void setRemote(boolean remote) {
        this.setAttribute(ATTR_WEBLOGIC_IS_REMOTE, remote);
        this.setBootPropUsed(!remote);
        this.setConfigFileUsed(!remote);
    }

    public void setTunneling(boolean tunneling) {
        this.setAttribute(ATTR_WEBLOGIC_IS_TUNNELING, tunneling);
    }

    public String getHostname() {
        if (this.isRemote()) {
            return this.getAttribute(ATTR_WEBLOGIC_HOSTNAME, DEFAULT_HOSTNAME);
        }
        return this.getServerInfo() != null ? this.getServerInfo().getHostName() : DEFAULT_HOSTNAME;
    }

    public void setHostname(String hostname) {
        this.setAttribute(ATTR_WEBLOGIC_HOSTNAME, hostname);
        this.setAttribute(PROP_HOSTNAME, hostname);
    }

    public int getPort() {
        if (this.isUseSSLPort()) {
            return this.getHttpsPort();
        }
        ServerInfo info = this.getServerInfo();
        if (info != null) {
            return info.getPortNumber();
        }
        return this.getAttribute(ATTR_WEBLOGIC_PORT, 7001);
    }

    public void setPort(int port) {
        this.setAttribute(ATTR_WEBLOGIC_PORT, port);
    }

    public void setHttpsPort(int port) {
        this.setAttribute(ATTR_WEBLOGIC_HTTPS_PORT, port);
    }

    public int getHttpsPort() {
        if (this.isRemote()) {
            return this.getAttribute(ATTR_WEBLOGIC_HTTPS_PORT, -1);
        }
        return this.getServerInfo().getHttpsPort();
    }

    public void setUseSSLPort(boolean useSSL) {
        this.setAttribute(ATTR_WEBLOGIC_USE_SSL_PORT, useSSL);
    }

    public boolean isUseSSLPort() {
        return this.getAttribute(ATTR_WEBLOGIC_USE_SSL_PORT, false);
    }

    public KeystoreType getKeystoreType() {
        ServerInfo info = this.getServerInfo();
        if (info != null) {
            return info.getKeystoreType();
        }
        return KeystoreType.DemoIdentityAndDemoTrust;
    }

    public String getCustomIdentityKeystore() {
        ServerInfo info = this.getServerInfo();
        if (info != null) {
            return info.getCustomIdentityKeystore();
        }
        return null;
    }

    public String getCustomTrustKeystore() {
        ServerInfo info = this.getServerInfo();
        if (info != null) {
            return info.getCustomTrustKeystore();
        }
        return null;
    }

    public Integer getDeploymentTimeout() {
        String timeout = this.getAttribute("deployment_timeout", null);
        if (timeout == null) {
            return 5;
        }
        return Integer.parseInt(timeout);
    }

    public String getProtocol() {
        boolean isUseSSL = this.isUseSSLPort();
        String protocol = isUseSSL ? "t3s" : "t3";
        boolean isTunneling = this.isTunneling();
        if (isTunneling) {
            protocol = isUseSSL ? "https" : "http";
        }
        return protocol;
    }

    public int getDebugPort() {
        return this.getAttribute(ATTR_WEBLOGIC_DEBUG_PORT, 8453);
    }

    public void setDebugPort(int port) {
        this.setAttribute(ATTR_WEBLOGIC_DEBUG_PORT, port);
    }

    @Override
    public boolean isConfigFileUsed() {
        String useCoonfig = this.getAttribute(ATTR_WEBLOGIC_USE_CONFIG_XML, "true");
        return useCoonfig.equals("true");
    }

    @Override
    public void setConfigFileUsed(boolean use) {
        this.setAttribute(ATTR_WEBLOGIC_USE_CONFIG_XML, use);
    }

    public String getUsername() {
        return this.getAttribute(ATTR_WEBLOGIC_USERNAME, DEFAULT_USERNAME);
    }

    public void setUsername(String name) {
        if (name.equals(DEFAULT_USERNAME)) {
            this.setAttribute(ATTR_WEBLOGIC_USERNAME, null);
        } else {
            this.setAttribute(ATTR_WEBLOGIC_USERNAME, name);
        }
    }

    public String getPassword() {
        String pass = this.getAttribute(ATTR_WEBLOGIC_PASSWORD, null);
        if (pass != null) {
            try {
                pass = StringEncrypter.getInstance().decrypt(pass);
                this.saveSecurePassword(pass);
                IServerWorkingCopy swc = this.getServer().createWorkingCopy();
                swc.setAttribute(ATTR_WEBLOGIC_PASSWORD, null);
                swc.save(true, (IProgressMonitor)new NullProgressMonitor());
                return pass;
            }
            catch (CoreException coreException) {}
        }
        return this.getSecurePassword();
    }

    public void setPassword(String pass) {
        this.saveSecurePassword(pass);
    }

    private String getSecurePassword() {
        try {
            ISecurePreferences root = SecurePreferencesFactory.getDefault();
            ISecurePreferences node = root.node("/oracle/eclipse/tools/oepe/weblogic" + this.getServer().getId());
            String passwd = node.get("password", DEFAULT_PASSWORD);
            return passwd;
        }
        catch (Exception e) {
            e.printStackTrace();
            return DEFAULT_PASSWORD;
        }
    }

    private void saveSecurePassword(String password) {
        try {
            ISecurePreferences root = SecurePreferencesFactory.getDefault();
            ISecurePreferences node = root.node("/oracle/eclipse/tools/oepe/weblogic" + this.getServer().getId());
            node.put("password", password, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TreeSet<Integer> getUserIgnoredWarnings() {
        TreeSet<Integer> ret = new TreeSet<Integer>();
        String ignoredWarnings = this.getAttribute(ATTR_IGNORED_WARNINGS, null);
        if (ignoredWarnings != null && ignoredWarnings.length() > 0) {
            String[] ids;
            String[] stringArray = ids = ignoredWarnings.split(",");
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                ret.add(Integer.valueOf(id));
                ++n2;
            }
        }
        return ret;
    }

    public void setUserIgnoredWarnings(Set<Integer> warnings) {
        StringBuilder sb = new StringBuilder();
        Iterator<Integer> it = warnings.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        this.setAttribute(ATTR_IGNORED_WARNINGS, sb.toString());
    }

    public static String encrypt(String word) {
        String ret = StringEncrypter.getInstance().encrypt(word);
        return ret;
    }

    private ServerInfo getBareServerInfo() {
        if (this.isRemote()) {
            String hostname = this.getHostname();
            int port = this.getAttribute(ATTR_WEBLOGIC_PORT, 7001);
            ServerInfo info = new ServerInfo(hostname, port);
            IRuntime runtime = this.getServer().getRuntime();
            WebLogicServerVersion wlsVersion = WebLogicServerVersion.detect(runtime.getLocation().toFile());
            if (wlsVersion != null) {
                info.setConfigVersion(wlsVersion.getVersionString());
            }
            return info;
        }
        throw new RuntimeException("Not implemented!");
    }

    private void setBareServerInfo(ServerInfo info) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public IPath getWeblogicHome() {
        IRuntime runtime = this.getServer().getRuntime();
        if (runtime == null) {
            return null;
        }
        return runtime.getLocation();
    }

    @Override
    public ServerInfo getServerInfo() {
        if (this.isRemote()) {
            return this.getBareServerInfo();
        }
        if (!this.isConfigFileUsed()) {
            return this.getBareServerInfo();
        }
        IPath domain = this.getDomainPath();
        if (domain == null || domain.isEmpty()) {
            return null;
        }
        try {
            ServerConfiguration serverConfig = this.getServerConfiguration();
            return serverConfig.getServerInfo();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private ServerConfiguration getServerConfiguration() throws CoreException {
        ServerConfiguration result = this.config;
        if (this.isRemote()) {
            this.config = result = new ServerConfiguration(this.getServerInfo());
            return result;
        }
        IPath domainPath = this.getDomainPath();
        IStatus status = WeblogicServer.validateDomainPath(domainPath);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        this.config = result == null ? (result = new ServerConfiguration(domainPath)) : (result = result.refresh(domainPath));
        return result;
    }

    @Override
    public void setServerInfo(ServerInfo info) {
        this.setBareServerInfo(info);
    }

    @Override
    public CredentialInfo getCredentialInfo() {
        if (this.isRemote()) {
            return new CredentialInfo(this.getUsername(), this.getPassword());
        }
        if (!this.isBootPropUsed()) {
            return new CredentialInfo(this.getUsername(), this.getPassword());
        }
        ServerInfo info = this.getServerInfo();
        if (info == null) {
            return null;
        }
        try {
            CredentialHelper helper = this.getBootProperties(this.getDomainPath(), info.getServerName());
            if (helper.isBootPropsFileExist()) {
                return helper.getCredential();
            }
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private CredentialHelper getBootProperties(IPath domainPath, String serverName) throws CoreException {
        if (this.isRemote()) {
            throw new RuntimeException("Not support on remote server!");
        }
        CredentialHelper result = this.cred;
        this.cred = result == null ? (result = new CredentialHelper(this.getServer(), this.getWeblogicHome(), domainPath, serverName)) : (result = result.refresh(domainPath, serverName));
        return result;
    }

    @Override
    public IStatus validate() {
        if (this.isRemote()) {
            return Status.OK_STATUS;
        }
        ValidationContext context = new ValidationContext();
        return this.validate(context, (IProgressMonitor)new NullProgressMonitor());
    }

    public IStatus validateRemote() {
        String remoteHost = this.getHostname().trim();
        if (remoteHost.length() == 0) {
            String msg = "Remote host name cannot be empty";
            return new Status(1, "oracle.eclipse.tools.weblogic", msg);
        }
        if (this.getPort() == -1) {
            String msg = "Invalid port number";
            if (this.isUseSSLPort()) {
                msg = "Invalid HTTPS port number";
            }
            return CorePlugin.createErrorStatus(msg);
        }
        if (this.getUsername().trim().length() == 0) {
            String msg = "User name is empty";
            return CorePlugin.createErrorStatus(msg);
        }
        if (this.getPassword().trim().length() == 0) {
            String msg = "Password is empty";
            return CorePlugin.createErrorStatus(msg);
        }
        return Status.OK_STATUS;
    }

    public IStatus validateCreatable(IProgressMonitor monitor) {
        if (this.isRemote()) {
            return Status.OK_STATUS;
        }
        ValidationContext context = new ValidationContext();
        IStatus status = this.validate(context, monitor);
        if (!status.isOK()) {
            return status;
        }
        return this.validateCreatable(context);
    }

    private IStatus validate(ValidationContext context, IProgressMonitor monitor) {
        IStatus status = CorePlugin.STATUS_OK;
        IRuntime runtime = this.getServer().getRuntime();
        if (runtime == null) {
            status = CorePlugin.createErrorStatus(CorePlugin.getString("errorServerNoRuntime", new Object[0]));
        }
        if (status.isOK()) {
            status = runtime.validate(null);
            monitor.worked(10);
            if (status.getSeverity() == 4) {
                return status;
            }
            status = WeblogicServer.validateDomain(context);
            monitor.worked(10);
            if (status.isOK()) {
                status = this.validateServerConfiguration(context);
                monitor.worked(10);
                if (status.isOK()) {
                    status = this.validateCredential(context);
                    monitor.worked(10);
                    if (status.isOK()) {
                        return CorePlugin.STATUS_OK;
                    }
                }
            } else {
                return status;
            }
        }
        String msg = CorePlugin.getString("errorServerInvalid", new Object[0]);
        return CorePlugin.createMultiStatus(msg, status);
    }

    private IStatus validateCreatable(ValidationContext context) {
        IStatus status = Paths.validateNonEmptyDirectory(context.domainPath);
        if (!status.isOK()) {
            return status;
        }
        IServerType[] types = ServerCore.getServerTypes();
        int i = 0;
        while (i < types.length) {
            IServerType type = types[i];
            if (type.getId().startsWith("com.bea.wlw.server") || type.getId().startsWith("com.bea.weblogic")) {
                IServer[] iServerArray = ServerCore.getServers();
                int n = iServerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IServer cmpServer = iServerArray[n2];
                    if (cmpServer.getServerType() != null && cmpServer.getServerType().equals(type) && this.getServer() != cmpServer) {
                        IPath cmpPath;
                        if (this.getServer().getId().equals(cmpServer.getId())) {
                            String msg = CorePlugin.getString("errorServerConfigDomainNameConflict", cmpServer.getName(), cmpServer.getName());
                            return CorePlugin.createErrorStatus(msg);
                        }
                        IWeblogicServer cmpWeblogic = (IWeblogicServer)cmpServer.loadAdapter(IWeblogicServer.class, null);
                        if (cmpWeblogic != null && (cmpPath = cmpWeblogic.getDomainPath()) != null && !cmpPath.isEmpty()) {
                            String cmpDomainName;
                            if (context.domainPath.equals((Object)cmpPath)) {
                                String msg = CorePlugin.getString("errorServerConfigPreviouslyDefined", context.domainPath, cmpServer.getName());
                                return CorePlugin.createErrorStatus(msg);
                            }
                            String domainName = context.domainPath.lastSegment();
                            if (domainName.equals(cmpDomainName = cmpWeblogic.getDomainPath().lastSegment())) {
                                // empty if block
                            }
                        }
                    }
                    ++n2;
                }
            }
            ++i;
        }
        status = this.validateRuntimeMatch(context);
        if (!status.isOK()) {
            return status;
        }
        return CorePlugin.STATUS_OK;
    }

    private IStatus validateRuntimeMatch(ValidationContext context) {
        context.info.hashCode();
        IRuntime runtime = this.getServer().getRuntime();
        if (runtime == null) {
            return CorePlugin.createErrorStatus(CorePlugin.getString("errorServerNoRuntime", new Object[0]), new Exception(), 7001);
        }
        IPath path = runtime.getLocation();
        try {
            IPath cmpPath = WeblogicServer.getWeblogicHomeFromDomainEnvScript(context.domainPath);
            File pathFile = ((Path)path).toFile();
            File cmpPathFile = ((Path)cmpPath).toFile();
            if (!pathFile.getCanonicalPath().equals(cmpPathFile.getCanonicalPath())) {
                String msg = CorePlugin.getString("errorServerConfigRuntimeMismatched", runtime.getName());
                return CorePlugin.createMultiStatus(msg, null, 7001, CorePlugin.createInfoStatus(msg, 7001));
            }
            return CorePlugin.STATUS_OK;
        }
        catch (IOException e) {
            String msg = CorePlugin.getString("errorServerConfigProbe", new Object[0]);
            return CorePlugin.createMultiStatus(msg, e, 4, new IStatus[0]);
        }
        catch (CoreException ce) {
            String msg = CorePlugin.getString("errorServerConfigProbe", new Object[0]);
            return CorePlugin.createMultiStatus(msg, ce.getStatus());
        }
    }

    private static IPath getWeblogicHomeFromDomainEnvScript(IPath domainPath) throws CoreException {
        Paths.validateShellScript(domainPath.append("bin"), "setDomainEnv");
        IPath scriptPath = domainPath.append("bin").append("setDomainEnv." + CorePlugin.getScriptExtension());
        try {
            IPath weblogicHome = WebLogicServerUtil.getWeblogicHomeFromDomainEnvScript(domainPath);
            if (weblogicHome == null) {
                String msg = CorePlugin.getString("errorServerWLHomeNotSetInScript", scriptPath);
                throw new CoreException(CorePlugin.createErrorStatus(msg));
            }
            return weblogicHome;
        }
        catch (FileNotFoundException fnfe) {
            String msg = CorePlugin.getString("errorServerWLHomeScriptNotFound", scriptPath);
            throw new CoreException(CorePlugin.createErrorStatus(msg, fnfe));
        }
        catch (IOException ioe) {
            String msg = CorePlugin.getString("errorServerWLHomeGeneral", scriptPath);
            throw new CoreException(CorePlugin.createErrorStatus(msg, ioe));
        }
    }

    private static IStatus validateDomain(ValidationContext context) {
        if (!context.useConfig && !context.useBootProp) {
            return CorePlugin.STATUS_OK;
        }
        return WeblogicServer.validateDomainPath(context.domainPath);
    }

    private static IStatus validateDomainPath(IPath root) {
        IStatus status = CorePlugin.STATUS_OK;
        status = Paths.validateNonEmptyDirectory(root);
        if (!status.isOK()) {
            return status;
        }
        status = Paths.validateRequiredFile(root, "config.xml");
        if (status.isOK()) {
            String msg = Resources.upgradeWls81DomainDesc;
            return CorePlugin.createMultiStatus(msg, null, 7001, CorePlugin.createInfoStatus(msg, 7001));
        }
        status = Paths.validateRequiredFile(root, "config/config.xml");
        if (!status.isOK()) {
            String msg = CorePlugin.getString("errorDomainPath", root.toOSString());
            return CorePlugin.createMultiStatus(msg, status);
        }
        return CorePlugin.STATUS_OK;
    }

    private IStatus validateServerConfiguration(ValidationContext context) {
        if (!this.isConfigFileUsed()) {
            context.info = this.getBareServerInfo();
        } else {
            if (context.domainPath.equals((Object)this.getDomainPath())) {
                try {
                    ServerConfiguration serverConfig = this.getServerConfiguration();
                    context.info = serverConfig.getServerInfo();
                }
                catch (CoreException ce) {
                    String msg = CorePlugin.getString("errorServerConfigProbe", new Object[0]);
                    return CorePlugin.createMultiStatus(msg, ce.getStatus());
                }
            }
            try {
                ServerConfiguration serverConfig = new ServerConfiguration(context.domainPath);
                context.info = serverConfig.getServerInfo();
            }
            catch (CoreException ce) {
                String msg = CorePlugin.getString("errorServerConfigProbe", new Object[0]);
                return CorePlugin.createMultiStatus(msg, ce.getStatus());
            }
        }
        if (context.info == null) {
            return CorePlugin.createErrorStatus(CorePlugin.getString("errorServerConfigProbe", new Object[0]));
        }
        if (context.info.getServerName() == null) {
            return CorePlugin.createErrorStatus(CorePlugin.getString("errorServerConfigMissingName", new Object[0]));
        }
        if (context.info.getPortNumber() <= 0) {
            return CorePlugin.createErrorStatus(CorePlugin.getString("errorServerConfigMissingPort", new Object[0]));
        }
        return CorePlugin.STATUS_OK;
    }

    public IStatus validateCredential(ValidationContext context) {
        if (this.isRemote()) {
            return Status.OK_STATUS;
        }
        assert (context.info != null);
        if (!context.useBootProp) {
            return CorePlugin.STATUS_OK;
        }
        String serverName = context.info.getServerName();
        String bootPropPath = "servers/" + serverName + "/security/boot.properties";
        IStatus status = Paths.validateRequiredFile(context.domainPath, bootPropPath);
        if (status.isOK()) {
            try {
                if (context.domainPath.equals((Object)this.getDomainPath())) {
                    this.getBootProperties(context.domainPath, context.info.getServerName());
                }
                this.cred = new CredentialHelper(this.getServer(), this.getWeblogicHome(), context.domainPath, context.info.getServerName());
            }
            catch (CoreException ce) {
                String msg = CorePlugin.getString("errorServerCredentialProbe", new Object[0]);
                return CorePlugin.createMultiStatus(msg, ce.getStatus());
            }
        } else {
            String msg = CorePlugin.getString("errorServerCredentialMissing", new Object[0]);
            return CorePlugin.createMultiStatus(msg, status);
        }
        return CorePlugin.STATUS_OK;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isDomainConifgEditLockOn() {
        block23: {
            editLockFile = new File(String.valueOf(this.getDomainPath().toOSString()) + "/edit.lok");
            if (editLockFile.exists()) {
                block22: {
                    editLockProp = new Properties();
                    fio = null;
                    fio = new FileInputStream(editLockFile);
                    editLockProp.load(fio);
                    if (editLockProp.getProperty("acquired") == null) break block22;
                    try {
                        if (fio != null) {
                            fio.close();
                        }
                    }
                    catch (IOException v0) {}
                    return true;
                    catch (FileNotFoundException v1) {
                        ** try [egrp 2[TRYBLOCK] [6 : 91->92)] { 
lbl17:
                        // 1 sources

                        try {
                            if (fio != null) {
                                fio.close();
                            }
                            break block23;
                        }
                        catch (IOException v2) {}
                        break block23;
                    }
                    catch (IOException v3) {
                        ** try [egrp 4[TRYBLOCK] [7 : 107->108)] { 
lbl-1000:
                        // 3 sources

                        {
                            catch (Throwable var4_4) {
                                try {
                                    if (fio != null) {
                                        fio.close();
                                    }
                                }
                                catch (IOException v4) {}
                                throw var4_4;
                            }
                        }
lbl33:
                        // 1 sources

                        try {
                            if (fio != null) {
                                fio.close();
                            }
                            break block23;
                        }
                        catch (IOException v5) {}
                        break block23;
                    }
                }
                try {
                    if (fio != null) {
                        fio.close();
                    }
                }
                catch (IOException v6) {}
            }
        }
        return false;
    }

    @Override
    protected IModule[] getRootModulesFromExtensions(IModule module) {
        ArrayList<IServerModuleHelper> helpers = WeblogicServer.getServerModuleHelper();
        for (IServerModuleHelper helper : helpers) {
            IModule[] ret = helper.getRootModules(module);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public void setSSLSystemProperties() {
        if (this.isUseSSLPort()) {
            String trustStorePath = this.getTrustStorePath();
            WebLogicServerUtil.setSSLKeyStoreAndHostnameVerifier(trustStorePath, this.getHostname());
        }
    }

    public String getTrustStorePath() {
        String storePath = System.getProperty("weblogic.security.SSL.trustedCAKeyStore", null);
        if (storePath != null) {
            return storePath;
        }
        String demoTrustStorePath = this.getServer().getRuntime().getLocation().append("/server/lib/DemoTrust.jks").toPortableString();
        if (new File(demoTrustStorePath).exists()) {
            return demoTrustStorePath;
        }
        return null;
    }

    public void setTrustStorePath(String trustStorePath) {
    }

    private static ArrayList<IServerModuleHelper> getServerModuleHelper() {
        if (serverModuleHelpers == null) {
            IConfigurationElement[] configs;
            ArrayList<IServerModuleHelper> list = new ArrayList<IServerModuleHelper>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extPoint = registry.getExtensionPoint(SERVER_MODULE_HELPER_EXT_POINT);
            IConfigurationElement[] iConfigurationElementArray = configs = extPoint.getConfigurationElements();
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement cfgElem = iConfigurationElementArray[n2];
                try {
                    Object obj = cfgElem.createExecutableExtension("class");
                    if (obj instanceof IServerModuleHelper) {
                        list.add((IServerModuleHelper)obj);
                    }
                }
                catch (CoreException coreException) {}
                ++n2;
            }
            serverModuleHelpers = list;
        }
        return serverModuleHelpers;
    }

    static final class Resources
    extends NLS {
        public static String facetNotSupported;
        public static String cannotBridgeRuntime;
        public static String upgradeWls81DomainDesc;

        static {
            Resources.initializeMessages((String)WeblogicServer.class.getName(), Resources.class);
        }

        Resources() {
        }
    }

    class ValidationContext {
        IPath domainPath;
        ServerInfo info;
        CredentialInfo cred;
        boolean useConfig;
        boolean useBootProp;

        ValidationContext() {
            this.domainPath = WeblogicServer.this.getDomainPath();
            this.useConfig = WeblogicServer.this.isConfigFileUsed();
            this.useBootProp = WeblogicServer.this.isBootPropUsed();
        }
    }
}

