/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.weblogic.server.internal.ClassloaderStructureHelper;
import oracle.eclipse.tools.weblogic.server.internal.util.ModuleUtil;
import oracle.eclipse.tools.weblogic.server.model.IWeblogicModule;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;

public class WeblogicModule
implements IWeblogicModule {
    private IWeblogicModule parent;
    private IModule module;
    private IModule[] path;
    private int kind;
    private IModuleResourceDelta[] delta;
    private boolean redeploy;
    private boolean fullredeploy;
    private List<IWeblogicModule> children;
    private String deployName;

    public WeblogicModule(IWeblogicModule parent, IModule module, String deployName) {
        this.parent = parent;
        this.module = module;
        this.deployName = deployName;
        this.children = new ArrayList<IWeblogicModule>();
    }

    public void setModulePath(IModule[] path) {
        this.path = path;
    }

    public void setKind(int kind) {
        this.kind = kind;
    }

    @Override
    public int getKind() {
        return this.kind;
    }

    public void setDelta(IModuleResourceDelta[] delta) {
        this.delta = delta;
    }

    @Override
    public IWeblogicModule getParent() {
        return this.parent;
    }

    @Override
    public IModule getModule() {
        return this.module;
    }

    @Override
    public IModule[] getModulePath() {
        return this.path;
    }

    @Override
    public String getDeployName() {
        return this.deployName;
    }

    @Override
    public IModuleResourceDelta[] getResourceDelta() {
        return this.delta;
    }

    @Override
    public boolean redeploy() {
        return this.redeploy;
    }

    @Override
    public void setRedeploy(boolean redeploy) {
        this.redeploy = redeploy;
        if (!redeploy) {
            return;
        }
        if (this.parent == null || ModuleUtil.isWebModule(this.module)) {
            return;
        }
        ClassloaderStructureHelper helper = new ClassloaderStructureHelper(this.parent);
        if (ModuleUtil.isEJBModule(this.module) && helper.hasCustomClassloader(this.deployName)) {
            return;
        }
        this.parent.setRedeploy(redeploy);
    }

    @Override
    public boolean fullRedeploy() {
        return this.fullredeploy;
    }

    @Override
    public void setFullRedeploy() {
        this.fullredeploy = true;
        if (this.parent == null || ModuleUtil.isWebModule(this.module)) {
            return;
        }
    }

    @Override
    public List<IWeblogicModule> getChildModules() {
        return this.children;
    }
}

