/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;

public class Trace {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy HH:mm.ss.SSS");
    private static Set<String> logged = new HashSet<String>();
    public static boolean CONFIG = false;
    public static boolean INFO = false;
    public static boolean WARNING = false;
    public static boolean SEVERE = false;
    public static boolean FINER = false;
    public static boolean FINEST = false;
    public static boolean RESOURCES = false;
    public static boolean EXTENSION_POINT = false;
    public static boolean LISTENERS = false;
    public static boolean RUNTIME_TARGET = false;
    public static boolean PERFORMANCE = false;
    public static boolean PUBLISHING = false;
    public static final String STRING_CONFIG = "/config";
    public static final String STRING_INFO = "/info";
    public static final String STRING_WARNING = "/warning";
    public static final String STRING_SEVERE = "/severe";
    public static final String STRING_FINER = "/finer";
    public static final String STRING_FINEST = "/finest";
    public static final String STRING_RESOURCES = "/resources";
    public static final String STRING_EXTENSION_POINT = "/extension_point";
    public static final String STRING_LISTENERS = "/listeners";
    public static final String STRING_RUNTIME_TARGET = "/runtime_target";
    public static final String STRING_PERFORMANCE = "/performance";
    public static final String STRING_PUBLISHING = "/publishing";

    public static void trace(String level, String s) {
        Trace.trace(level, s, null);
    }

    public static void trace(String level, String s, Throwable t) {
        if (s == null) {
            return;
        }
        if (STRING_SEVERE.equals(level) && !logged.contains(s)) {
            LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (Throwable)t, (String)s);
            logged.add(s);
        }
        if (WlsCorePlugin.getInstance().isDebugging()) {
            StringBuffer sb = new StringBuffer("oracle.eclipse.tools.weblogic");
            sb.append(" ");
            sb.append(level);
            sb.append(" ");
            sb.append(sdf.format(new Date()));
            sb.append(" ");
            sb.append(s);
            System.out.println(sb.toString());
            if (t != null) {
                t.printStackTrace();
            }
        }
    }
}

