/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import oracle.eclipse.tools.common.util.system.ExecHelper;
import oracle.eclipse.tools.common.util.system.RuntimeResponse;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.IWeblogicDomainConfigurator;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntime;
import oracle.eclipse.tools.weblogic.server.internal.DomainConfigurator;
import oracle.eclipse.tools.weblogic.server.internal.ServerConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IRuntime;

public class SilentScriptDomainConfigurator
extends DomainConfigurator
implements IWeblogicDomainConfigurator {
    private static final String TEMPLATE_JAR = "wls.jar";
    private static final String TEMPLATE_EX_PATH = "common" + SEPARATOR + "templates" + SEPARATOR + "applications";
    private static final String TEMPLATE_EX_JAR = "weblogic-beehive.jar";
    private static final String TEMPLATE_WLS_CONV = "wls_conv.jar";
    private static final String LOG_FILENAME = "create_domain.log";
    private static final String SCRIPT_FILENAME = "wlw_create_domain";
    private static final String SCRIPT_EXT = "sls";
    private IPath domainPath = Path.EMPTY;
    private String username;
    private String ticket;

    @Override
    public void initialize(IRuntime runtime, IProgressMonitor monitor) {
        runtime.hashCode();
        this.username = "weblogic";
        this.ticket = "weblogic";
        this.runtime = runtime;
        this.weblogic = (IWeblogicServerRuntime)runtime.loadAdapter(IWeblogicServerRuntime.class, monitor);
        this.weblogic.hashCode();
        this.domainPath = this.guessNewPath();
    }

    private IPath guessNewPath() {
        IPath path = this.runtime.getLocation();
        if (path != null && !path.isEmpty()) {
            path = path.removeLastSegments(1);
            path = path.append("user_projects");
            path = path.append("domains");
        } else {
            path = new Path(System.getProperty("value.win.newdomain.base.0"));
        }
        if (SilentScriptDomainConfigurator.validateLocation(path.append("mydomain")).isOK()) {
            return path.append("mydomain");
        }
        int suf = 0;
        while (suf < 200) {
            IPath domainPath = path.append("mydomain" + suf);
            if (SilentScriptDomainConfigurator.validateLocation(domainPath).isOK()) {
                return domainPath;
            }
            ++suf;
        }
        return Path.EMPTY;
    }

    @Override
    public void setDomainPath(IPath domainPath) {
        domainPath.hashCode();
        this.domainPath = domainPath;
    }

    @Override
    public IPath getDomainPath() {
        return this.domainPath;
    }

    @Override
    public void setCredential(String username, String password) {
        this.username = username;
        this.ticket = password;
    }

    @Override
    public IStatus validate() {
        IStatus status = super.validate();
        if (!status.isOK()) {
            return status;
        }
        status = SilentScriptDomainConfigurator.validateLocation(this.domainPath);
        if (!status.isOK()) {
            return status;
        }
        status = SilentScriptDomainConfigurator.validateDomainName(this.domainPath);
        if (!status.isOK()) {
            return status;
        }
        String host = ServerConfiguration.getNonLoopbackLocalHost();
        if (host == null || host.trim().length() == 0) {
            String msg = CorePlugin.getString("errorServerConfigHostname", new Object[0]);
            return CorePlugin.createErrorStatus(msg);
        }
        return CorePlugin.STATUS_OK;
    }

    protected static IStatus validateLocation(IPath domainPath) {
        if (domainPath.isEmpty()) {
            String msg = CorePlugin.getString("msgWizardDomainCreationSelectPath", new Object[0]);
            return CorePlugin.createInfoStatus(msg);
        }
        if (domainPath.toFile().exists()) {
            File file = domainPath.toFile();
            if (!file.isDirectory()) {
                String msg = CorePlugin.getString("errorPathNotDir", domainPath.toOSString());
                return CorePlugin.createErrorStatus(msg);
            }
            if (file.list() != null && file.list().length != 0) {
                String msg = CorePlugin.getString("errorDirNotEmpty", domainPath.toOSString());
                return CorePlugin.createErrorStatus(msg);
            }
        } else {
            IPath parentPath = domainPath.removeLastSegments(1);
            while (parentPath.segmentCount() > 0) {
                if (parentPath.toFile().exists() && !parentPath.toFile().isDirectory()) {
                    String msg = CorePlugin.getString("errorInvalidPath", new Object[0]);
                    return CorePlugin.createErrorStatus(msg);
                }
                parentPath = parentPath.removeLastSegments(1);
            }
        }
        return CorePlugin.STATUS_OK;
    }

    protected static IStatus validateDomainName(IPath domainPath) {
        if (domainPath.isEmpty()) {
            String msg = CorePlugin.getString("errorPathEmptyDir", domainPath.toOSString());
            return CorePlugin.createErrorStatus(msg);
        }
        String domainName = domainPath.lastSegment();
        if (domainName.length() == 0) {
            String msg = CorePlugin.getString("errorPathEmptyDir", domainPath.toOSString());
            return CorePlugin.createErrorStatus(msg);
        }
        if (domainName.indexOf(32) >= 0) {
            String msg = CorePlugin.getString("errorPathWithSpace", domainPath.toOSString());
            return CorePlugin.createErrorStatus(msg);
        }
        if (CorePlugin.IS_WINDOWS) {
            int i = 0;
            int len = domainPath.segmentCount();
            while (i < len) {
                String seg = domainPath.segment(i);
                if (seg.indexOf(32) >= 0) {
                    String msg = CorePlugin.getString("errorPathWithSpace", domainPath.toOSString());
                    return CorePlugin.createErrorStatus(msg);
                }
                ++i;
            }
        }
        return CorePlugin.STATUS_OK;
    }

    @Override
    public void apply(IProgressMonitor monitor) throws CoreException {
        try {
            IStatus status = this.validate();
            if (!status.isOK()) {
                throw new CoreException(status);
            }
            this.execute(monitor);
        }
        finally {
            monitor.done();
        }
    }

    private void execute(IProgressMonitor monitor) throws CoreException {
        String[] list;
        IPath javaPath = this.weblogic.getJavaVmLocation();
        String javaHome = javaPath.toString();
        IPath wlPath = this.runtime.getLocation();
        String wlHome = wlPath.toString();
        String domainRoot = this.domainPath.toString();
        File script = null;
        File domain = null;
        domain = new File(domainRoot);
        if (domain.exists() && (list = domain.list()) != null && list.length != 0) {
            String msg = CorePlugin.getString("errorPathEmptyDir", domainRoot);
            throw new CoreException(CorePlugin.createErrorStatus(msg));
        }
        String hostname = ServerConfiguration.getNonLoopbackLocalHost();
        monitor.beginTask(CorePlugin.getString("msgWizardCreateDomain", new Object[0]), 100);
        monitor.subTask(CorePlugin.getString("msgWizardGenScript", new Object[0]));
        script = SilentScriptDomainConfigurator.generateScriptFile(javaHome, domainRoot, wlHome, domainRoot, hostname, this.username, this.ticket);
        monitor.worked(20);
        monitor.subTask(CorePlugin.getString("msgWizardGenScript", new Object[0]));
        monitor.worked(5);
        SilentScriptDomainConfigurator.invoke(monitor, script.getAbsolutePath(), domainRoot, wlHome, this.ticket);
        monitor.worked(65);
        monitor.done();
    }

    private static void invoke(IProgressMonitor monitor, String script, String domainRoot, String wlHome, String password) throws CoreException {
        String[] cmd = null;
        String termName = CorePlugin.getString("msgTerminalCreateDomain", new Object[0]);
        String command = "config." + CorePlugin.getScriptExtension();
        if (CorePlugin.IS_WINDOWS) {
            cmd = new String[]{"cmd.exe", "/C", "START", "\"" + termName + "\"", "/MIN", "/WAIT", "cmd.exe", "/C", "\"" + command + "\"", "-mode=silent", "-silent_script=" + script, "-log=" + domainRoot + "_" + LOG_FILENAME};
        } else if (CorePlugin.IS_UNIX) {
            cmd = new String[]{"xterm", "-T", termName, "-e", "sh", command, "-mode=silent", "-silent_script=" + script, "-log=" + domainRoot + "_" + LOG_FILENAME};
        } else {
            String msg = CorePlugin.getString("errorWizardUnsupportedOS", new Object[0]);
            throw new CoreException(CorePlugin.createErrorStatus(msg));
        }
        try {
            File execDir = new File(String.valueOf(wlHome) + SEPARATOR + BIN_PATH);
            Thread.yield();
            RuntimeResponse res = ExecHelper.async((String[])cmd, (File)execDir, (String)"Domain configurator");
            boolean done = res.isDone();
            while (!done) {
                try {
                    res.join();
                    done = res.isDone();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException ioe) {
            throw new CoreException(CorePlugin.createErrorStatus(ioe.getMessage(), ioe));
        }
    }

    private static void config(File script, String javaHome, String wlHome, String domainRoot, String hostname, String username, String password) throws CoreException {
        PrintStream ps = null;
        try {
            try {
                ps = new PrintStream(script, "UTF-8");
                ps.printf("read template from \"%1$s%4$s%2$s%4$s%3$s\";%n", wlHome, TEMPLATE_PATH, TEMPLATE_JAR, SEPARATOR);
                ps.printf("set OverwriteDomain \"true\";%n", new Object[0]);
                ps.printf("find User \"%1$s\" as u1;%n", username);
                ps.printf("set u1.password \"%1$s\";%n", password);
                ps.print("set ServerStartMode \"dev\";%n");
                ps.printf("set JavaHome \"%1$s\";%n", javaHome);
                ps.printf("find Server \"AdminServer\" as s1;%n", new Object[0]);
                ps.printf("write domain to \"%1$s\";%n", domainRoot);
                ps.printf("close template;%n", new Object[0]);
                ps.printf("read domain from \"%1$s\";%n", domainRoot);
                ps.printf("add template \"%1$s%4$s%2$s%4$s%3$s\";%n", wlHome, TEMPLATE_EX_PATH, TEMPLATE_WLS_CONV, SEPARATOR);
                ps.printf("add template \"%1$s%4$s%2$s%4$s%3$s\";%n", wlHome, TEMPLATE_EX_PATH, TEMPLATE_EX_JAR, SEPARATOR);
                ps.printf("update domain;%n", new Object[0]);
                ps.printf("close domain;%n", new Object[0]);
                ps.flush();
            }
            catch (FileNotFoundException fileNotFoundException) {
                String msg = CorePlugin.getString("errorFileCreation", script.toString());
                throw new CoreException(CorePlugin.createErrorStatus(msg));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (ps == null) {
                    return;
                }
                ps.close();
            }
        }
        finally {
            if (ps == null) {
                return;
            }
            ps.close();
        }
    }

    private static File generateScriptFile(String javaHome, String dirPath, String wlHome, String domainRoot, String hostname, String username, String password) throws CoreException {
        File dir = new File(dirPath);
        if (!dir.exists() && !dir.mkdirs()) {
            String msg = CorePlugin.getString("errorPathCreation", dirPath);
            throw new CoreException(CorePlugin.createErrorStatus(msg));
        }
        try {
            File file = null;
            int i = 0;
            while (i < 1000) {
                String filePath = "wlw_create_domain_" + i + "." + SCRIPT_EXT;
                file = new File(dir, filePath);
                if (!file.exists() && file.createNewFile()) {
                    SilentScriptDomainConfigurator.config(file, javaHome, wlHome, domainRoot, hostname, username, password);
                    return file;
                }
                ++i;
            }
            String msg = CorePlugin.getString("errorFileCreation", "wlw_create_domain_x.sls");
            throw new CoreException(CorePlugin.createErrorStatus(msg));
        }
        catch (IOException ioe) {
            throw new CoreException(CorePlugin.createErrorStatus(ioe.getMessage(), ioe));
        }
    }
}

