/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.ServerInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ServerConfiguration {
    private static final NetworkInterface[] NET_INTERFACES = ServerConfiguration.prepareNetInterfaceList();
    private final IPath domainPath;
    private ServerInfo adminServerInfo;
    private boolean serverRemote;
    private long lastModified;
    private boolean diabloVersion;

    public ServerConfiguration(IPath domainPath) throws CoreException {
        domainPath.hashCode();
        this.domainPath = domainPath;
        this.parse();
    }

    public ServerConfiguration(ServerInfo serverInfo) {
        this.domainPath = null;
        this.adminServerInfo = serverInfo;
    }

    public ServerInfo getServerInfo() {
        return this.adminServerInfo;
    }

    public boolean isServerRemote() {
        return this.serverRemote;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public IPath getDomainPath() {
        return this.domainPath;
    }

    public boolean isDiablo() {
        return this.diabloVersion;
    }

    protected synchronized void setAll(ServerInfo info, boolean serverRemote, boolean diablo, long lastModified) {
        this.adminServerInfo = info;
        this.lastModified = lastModified;
        this.serverRemote = serverRemote;
        this.diabloVersion = diablo;
    }

    public ServerConfiguration refresh(IPath domain) throws CoreException {
        domain.hashCode();
        if (this.domainPath != null && this.domainPath.equals((Object)domain)) {
            return this.refresh();
        }
        return new ServerConfiguration(domain);
    }

    public ServerConfiguration refresh() throws CoreException {
        File configFile = new File(this.domainPath.toFile(), "config/config.xml");
        File oldConfigFile = new File(this.domainPath.toFile(), "config.xml");
        if (configFile.exists() ? this.isDiablo() && this.lastModified == configFile.lastModified() : oldConfigFile.exists() && !this.isDiablo() && this.lastModified == configFile.lastModified()) {
            return this;
        }
        ServerConfiguration result = new ServerConfiguration(this.domainPath);
        return result;
    }

    protected void parse() throws CoreException {
        try {
            boolean diablo;
            ServerInfo serverInfo;
            long lastModified;
            File configFile = new File(this.domainPath.toFile(), "config/config.xml");
            File oldConfigFile = new File(this.domainPath.toFile(), "config.xml");
            if (configFile.exists()) {
                lastModified = configFile.lastModified();
                serverInfo = this.parseDiabloConfig(configFile);
                diablo = true;
            } else if (oldConfigFile.exists()) {
                lastModified = oldConfigFile.lastModified();
                serverInfo = this.parseEightOneConfig(oldConfigFile);
                diablo = false;
            } else {
                String msg = String.valueOf(CorePlugin.getString("errorServerConfigStructure", new Object[0])) + this.domainPath;
                throw new CoreException(CorePlugin.createErrorStatus(msg));
            }
            boolean serverRemote = !ServerConfiguration.isLocalHost(serverInfo.getHostName());
            this.setAll(serverInfo, serverRemote, diablo, lastModified);
        }
        catch (RuntimeException re) {
            String msg = CorePlugin.getString("errorServerConfigRuntimeException", new Object[0]);
            throw new CoreException(CorePlugin.createErrorStatus(msg, re));
        }
    }

    protected ServerInfo parseDiabloConfig(File configFile) throws CoreException {
        String domainName = null;
        String confVersion = null;
        Element root = ServerConfiguration.parse(configFile);
        NodeList dnodes = root.getChildNodes();
        String adminServerName = null;
        int i = 0;
        while (i < dnodes.getLength()) {
            String dname;
            Node dnode = dnodes.item(i);
            if (dnode.getNodeType() == 1 && (dname = dnode.getNodeName()) != null && (dname.equals("con:admin-server-name") || dname.equals("admin-server-name"))) {
                adminServerName = dnode.getTextContent();
            }
            ++i;
        }
        if (adminServerName == null) {
            String msg = CorePlugin.getString("errorServerConfigMissingName", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        ArrayList<ServerInfo> servers = new ArrayList<ServerInfo>();
        HashSet<String> clusters = new HashSet<String>();
        int i2 = 0;
        while (i2 < dnodes.getLength()) {
            String dname;
            Node dnode = dnodes.item(i2);
            if (dnode.getNodeType() == 1 && (dname = dnode.getNodeName()) != null) {
                if (dname.equals("con:name") || dname.equals("name")) {
                    domainName = dnode.getTextContent();
                } else if (dname.equals("con:configuration-version") || dname.equals("configuration-version")) {
                    confVersion = dnode.getTextContent();
                } else if (dname.equals("con:domain-version") || dname.equals("domain-version")) {
                    confVersion = dnode.getTextContent();
                } else if (dname.equals("con:cluster") || dname.equals("cluster")) {
                    NodeList snodes = dnode.getChildNodes();
                    int j = 0;
                    while (j < snodes.getLength()) {
                        String val;
                        String sname;
                        Node snode = snodes.item(j);
                        if (snode.getNodeType() == 1 && ((sname = snode.getNodeName()).equals("con:name") || sname.equals("name")) && !(val = snode.getTextContent()).equals(adminServerName)) {
                            clusters.add(val);
                            break;
                        }
                        ++j;
                    }
                } else if (dname.equals("con:server") || dname.equals("server")) {
                    ServerInfo serverInfo = this.parseServerInfo(dnode, domainName, confVersion);
                    if (serverInfo.getServerName().equals(adminServerName)) {
                        this.adminServerInfo = serverInfo;
                    } else {
                        servers.add(serverInfo);
                    }
                }
            }
            ++i2;
        }
        if (this.adminServerInfo == null) {
            String msg = CorePlugin.getString("errorServerConfigMissingName", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        this.adminServerInfo.setManagedServers(servers);
        this.adminServerInfo.setClusterNames(clusters);
        return this.adminServerInfo;
    }

    private ServerInfo parseServerInfo(Node dnode, String domainName, String confVersion) {
        int portNumber = 7001;
        int httpsPortNumber = 7002;
        boolean sslEnabled = false;
        String serverName = null;
        String hostName = "localhost";
        String clusterBelongsTo = null;
        String keystoreType = null;
        String customTrustKeystore = null;
        String customIdentityKeystore = null;
        boolean isListenPortDisabled = false;
        NodeList snodes = dnode.getChildNodes();
        int j = 0;
        while (j < snodes.getLength()) {
            Node snode = snodes.item(j);
            if (snode.getNodeType() == 1) {
                String sname = snode.getNodeName();
                if (sname.equals("con:name") || sname.equals("name")) {
                    serverName = snode.getTextContent();
                } else if (sname.equals("con:key-stores") || sname.equals("key-stores")) {
                    keystoreType = snode.getTextContent();
                } else if (sname.equals("con:custom-identity-key-store-file-name") || sname.equals("custom-identity-key-store-file-name")) {
                    customIdentityKeystore = snode.getTextContent();
                } else if (sname.equals("con:custom-trust-key-store-file-name") || sname.equals("custom-trust-key-store-file-name")) {
                    customTrustKeystore = snode.getTextContent();
                } else if (sname.equals("con:listen-address") || sname.equals("listen-address")) {
                    hostName = snode.getTextContent();
                    if (hostName.indexOf(58) >= 0 && (hostName.charAt(0) != '[' || hostName.charAt(hostName.length() - 1) != ']')) {
                        hostName = "[" + hostName + "]";
                    }
                    if (hostName == null || hostName.length() == 0) {
                        hostName = "localhost";
                    }
                } else if (sname.equals("con:listen-port") || sname.equals("listen-port")) {
                    String port = snode.getTextContent();
                    if (port.length() != 0) {
                        try {
                            portNumber = Integer.parseInt(port);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else if (sname.equals("con:listen-port-enabled") || sname.equals("listen-port-enabled")) {
                    String portEnabled = snode.getTextContent();
                    if ("false".equals(portEnabled)) {
                        isListenPortDisabled = true;
                    }
                } else if (sname.equals("con:cluster") || sname.equals("cluster")) {
                    clusterBelongsTo = snode.getTextContent();
                } else if (sname.equals("con:ssl") || sname.equals("ssl")) {
                    NodeList schildnodes = snode.getChildNodes();
                    int k = 0;
                    while (k < schildnodes.getLength()) {
                        Node schildnode = schildnodes.item(k);
                        if (schildnode.getNodeType() == 1) {
                            String sslFlag;
                            String schildname = schildnode.getNodeName();
                            if (schildname.equals("con:listen-port") || schildname.equals("listen-port")) {
                                String httpsPort = schildnode.getTextContent();
                                if (httpsPort.length() != 0) {
                                    try {
                                        httpsPortNumber = Integer.parseInt(httpsPort);
                                    }
                                    catch (NumberFormatException numberFormatException) {}
                                }
                            } else if ((schildname.equals("con:enabled") || schildname.equals("enabled")) && (sslFlag = schildnode.getTextContent()) != null && ("true".equals(sslFlag) || "TRUE".equals(sslFlag))) {
                                sslEnabled = true;
                            }
                        }
                        ++k;
                    }
                }
            }
            ++j;
        }
        ServerInfo info = new ServerInfo(serverName, domainName, hostName, portNumber, sslEnabled ? httpsPortNumber : -1, confVersion);
        info.setCluster(clusterBelongsTo);
        info.setListenPortDisabled(isListenPortDisabled);
        info.setKeystoreType(keystoreType);
        info.setCustomIdentityKeystore(customIdentityKeystore);
        info.setCustomTrustKeystore(customTrustKeystore);
        return info;
    }

    protected ServerInfo parseEightOneConfig(File configFile) throws CoreException {
        int portNumber = 7001;
        int httpsPortNumber = 7002;
        boolean sslEnabled = false;
        String domainName = null;
        String serverName = null;
        String hostName = null;
        InputStream in = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            try {
                DocumentBuilder docBuilder = factory.newDocumentBuilder();
                in = new BufferedInputStream(new FileInputStream(configFile));
                Element rootNode = docBuilder.parse(in).getDocumentElement();
                NamedNodeMap attr = rootNode.getAttributes();
                Node domainNameNode = attr.getNamedItem("Name");
                domainName = domainNameNode.getNodeValue();
                NodeList nodes = rootNode.getChildNodes();
                int i = 0;
                while (i < nodes.getLength()) {
                    Element el;
                    String elName;
                    Node node = nodes.item(i);
                    if (node.getNodeType() == 1 && (elName = (el = (Element)node).getNodeName()).equals("Server")) {
                        serverName = el.getAttribute("Name");
                        hostName = el.getAttribute("ListenAddress");
                        if (hostName.length() == 0) {
                            hostName = "localhost";
                        }
                        String portStr = el.getAttribute("ListenPort");
                        portNumber = 7001;
                        if (portStr.length() != 0) {
                            try {
                                portNumber = Integer.parseInt(portStr);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        NodeList cnodes = el.getChildNodes();
                        int j = 0;
                        while (j < cnodes.getLength()) {
                            Element childElement;
                            Node cnode = cnodes.item(j);
                            if (cnode.getNodeType() == 1 && (childElement = (Element)cnode).getNodeName().equals("SSL")) {
                                String sslFlag;
                                String httpsPort = childElement.getAttribute("ListenPort");
                                if (httpsPort.length() != 0) {
                                    try {
                                        httpsPortNumber = Integer.parseInt(httpsPort);
                                    }
                                    catch (NumberFormatException numberFormatException) {}
                                }
                                if ((sslFlag = childElement.getAttribute("Enabled")) != null && ("true".equals(sslFlag) || "TRUE".equals(sslFlag))) {
                                    sslEnabled = true;
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = CorePlugin.getString("errorServerConfigInvalidOrInaccessible", new Object[0]);
                throw new CoreException(CorePlugin.createErrorStatus(msg, e));
            }
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {}
        if (serverName == null) {
            String msg = CorePlugin.getString("errorServerConfigMissingName", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        ServerInfo ret = new ServerInfo(serverName, domainName, hostName, portNumber, sslEnabled ? httpsPortNumber : -1, null);
        return ret;
    }

    public static boolean isLocalHost(String hostname) {
        int i = 0;
        while (i < NET_INTERFACES.length) {
            Enumeration<InetAddress> addresses = NET_INTERFACES[i].getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address.getHostAddress().equals(hostname)) {
                    return true;
                }
                if (!address.getHostName().equals(hostname)) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    static boolean isLoopback(String hostname) {
        int i = 0;
        while (i < NET_INTERFACES.length) {
            Enumeration<InetAddress> addresses = NET_INTERFACES[i].getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (!address.isLoopbackAddress()) continue;
                if (address.getHostAddress().equals(hostname)) {
                    return true;
                }
                if (!address.getHostName().equals(hostname)) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    static String getNonLoopbackLocalHost() {
        int i = 0;
        while (i < NET_INTERFACES.length) {
            Enumeration<InetAddress> addresses = NET_INTERFACES[i].getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address.isLoopbackAddress()) continue;
                return address.getHostName();
            }
            ++i;
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Element parse(File f) throws CoreException {
        Element element;
        if (!f.exists() || !f.isFile()) {
            String msg = CorePlugin.getString("errorPathInvalid", f.getPath());
            throw new CoreException(CorePlugin.createErrorStatus(msg));
        }
        if (!f.canRead()) {
            String msg = CorePlugin.getString("errorServerConfigInaccessible", f.getPath());
            throw new CoreException(CorePlugin.createErrorStatus(msg));
        }
        InputStream in = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            in = new BufferedInputStream(new FileInputStream(f));
            element = builder.parse(in).getDocumentElement();
            if (in == null) return element;
        }
        catch (ParserConfigurationException pce) {
            try {
                String msg = CorePlugin.getString("errorServerConfigParserSetup", new Object[0]);
                throw new CoreException(CorePlugin.createErrorStatus(msg, pce));
                catch (SAXException saxe) {
                    msg = CorePlugin.getString("errorServerConfigElement", new Object[0]);
                    throw new CoreException(CorePlugin.createErrorStatus(msg, saxe));
                }
                catch (IOException ioe) {
                    msg = CorePlugin.getString("errorServerConfigInvalidOrInaccessible", new Object[0]);
                    throw new CoreException(CorePlugin.createErrorStatus(msg, ioe));
                }
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            in.close();
            return element;
        }
        catch (IOException iOException) {}
        return element;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Element parse(ZipFile zip, String path) throws CoreException {
        Element element;
        ZipEntry entry = zip.getEntry(path);
        if (entry == null) {
            String msg = CorePlugin.getString("errorPathInvalid", String.valueOf(zip.getName()) + " " + path);
            throw new CoreException(CorePlugin.createErrorStatus(msg));
        }
        InputStream in = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            in = new BufferedInputStream(zip.getInputStream(entry));
            element = builder.parse(in).getDocumentElement();
            if (in == null) return element;
        }
        catch (ParserConfigurationException pce) {
            try {
                String msg = CorePlugin.getString("errorServerConfigParserSetup", new Object[0]);
                throw new CoreException(CorePlugin.createErrorStatus(msg, pce));
                catch (SAXException saxe) {
                    msg = CorePlugin.getString("errorServerConfigElement", new Object[0]);
                    throw new CoreException(CorePlugin.createErrorStatus(msg, saxe));
                }
                catch (IOException ioe) {
                    msg = CorePlugin.getString("errorServerConfigInvalidOrInaccessible", new Object[0]);
                    throw new CoreException(CorePlugin.createErrorStatus(msg, ioe));
                }
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            in.close();
            return element;
        }
        catch (IOException iOException) {}
        return element;
    }

    private static NetworkInterface[] prepareNetInterfaceList() {
        Enumeration<NetworkInterface> interfaces = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<NetworkInterface> nets = new ArrayList<NetworkInterface>();
        if (interfaces != null) {
            while (interfaces.hasMoreElements()) {
                nets.add(interfaces.nextElement());
            }
        }
        return nets.toArray(new NetworkInterface[nets.size()]);
    }
}

