/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.util.FacetUtil;
import oracle.eclipse.tools.weblogic.server.internal.util.ModuleUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.componentcore.util.EARVirtualComponent;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.core.internal.J2EEUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.Module;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.model.ServerDelegate;
import org.eclipse.wst.server.core.util.ProjectModule;

public abstract class AbstractWeblogicServer
extends ServerDelegate {
    private static final IModule[] EMPTY_MODULES = new IModule[0];

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        if (add == null || add.length == 0) {
            return Status.OK_STATUS;
        }
        IModule[] iModuleArray = add;
        int n = add.length;
        int n2 = 0;
        while (n2 < n) {
            IModule module = iModuleArray[n2];
            if (ModuleUtil.isUtilityModule(module)) {
                return CorePlugin.createErrorStatus("Utility project cannot be added as top level module to this server");
            }
            if (ModuleUtil.isWebFragmentModule(module)) {
                return CorePlugin.createErrorStatus("Web fragment project cannot be added as top level module to this server");
            }
            IStatus st = this.checkModule(module);
            if (st.getSeverity() == 4) {
                return st;
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    protected IStatus checkModule(IModule module) {
        return this.canSupportModule(module);
    }

    public IStatus canSupportModule(IModule module) {
        IProject proj = module.getProject();
        if (proj == null) {
            return WlsCorePlugin.createErrorStatus("module type not supported");
        }
        if (proj != null) {
            try {
                IFacetedProject fproj = ProjectFacetsManager.create((IProject)module.getProject());
                if (fproj != null) {
                    org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = RuntimeBridgeUtil.bridge((IRuntime)this.getServer().getRuntime());
                    if (runtime == null) {
                        return WlsCorePlugin.createErrorStatus(WeblogicServer.Resources.cannotBridgeRuntime);
                    }
                    for (IProjectFacetVersion fv : fproj.getProjectFacets()) {
                        if (runtime.supports(fv)) continue;
                        String msg = WeblogicServer.Resources.bind((String)WeblogicServer.Resources.facetNotSupported, (Object)fv.toString());
                        return WlsCorePlugin.createErrorStatus(msg);
                    }
                }
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
        IModule[] iModuleArray = this.getChildModules(new IModule[]{module});
        int n = iModuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModule child = iModuleArray[n2];
            IStatus st = this.canSupportModule(child);
            if (st.getSeverity() == 4) {
                return st;
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    public IModule[] getChildModules(IModule[] modulePath) {
        IModule module = modulePath[modulePath.length - 1];
        IProject project = module.getProject();
        if (project == null || !project.exists() || !project.isOpen()) {
            return EMPTY_MODULES;
        }
        try {
            IWebModule web;
            IFacetedProject facet = ProjectFacetsManager.create((IProject)module.getProject());
            if (facet.hasProjectFacet(FacetUtil.FACET_JST_EAR)) {
                IEnterpriseApplication ea = (IEnterpriseApplication)module.loadAdapter(IEnterpriseApplication.class, null);
                HashMap<String, IModule> childModules = new HashMap<String, IModule>();
                if (ea != null) {
                    IModule[] iModuleArray = ea.getModules();
                    int n = iModuleArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IModule m = iModuleArray[n2];
                        childModules.put(m.getName(), m);
                        ++n2;
                    }
                }
                IModule[] allModules = ServerUtil.getModules((IModuleType[])this.getServer().getServerType().getRuntimeType().getModuleTypes());
                EARVirtualComponent earComp = (EARVirtualComponent)ComponentCore.createComponent((IProject)module.getProject());
                if (earComp != null) {
                    IProject earProj = module.getProject();
                    IVirtualReference[] iVirtualReferenceArray = earComp.getAllReferences();
                    int n = iVirtualReferenceArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IVirtualReference ref = iVirtualReferenceArray[n3];
                        IVirtualComponent vcomp = ref.getReferencedComponent();
                        IProject p = vcomp.getProject();
                        if (p != null && p != earProj) {
                            IModule[] iModuleArray = allModules;
                            int n4 = allModules.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                IModule m = iModuleArray[n5];
                                if (m.getProject() == p && !childModules.containsKey(m.getName())) {
                                    childModules.put(m.getName(), m);
                                }
                                ++n5;
                            }
                        }
                        ++n3;
                    }
                }
                Collection list = childModules.values();
                return list.toArray(new IModule[list.size()]);
            }
            if (facet.hasProjectFacet(FacetUtil.FACET_JST_WEB) && (web = (IWebModule)module.loadAdapter(IWebModule.class, null)) != null) {
                return web.getModules();
            }
            ProjectModule m = (ProjectModule)module.loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
            return m.getChildModules();
        }
        catch (RuntimeException re) {
            CorePlugin.getLevelLog().log(CorePlugin.createErrorStatus("Error in getChildModules()" + Arrays.toString(modulePath), re));
            return EMPTY_MODULES;
        }
        catch (CoreException re) {
            CorePlugin.getLevelLog().log(CorePlugin.createErrorStatus("Error in getChildModules()" + Arrays.toString(modulePath), re));
            return EMPTY_MODULES;
        }
    }

    public IModule[] getRootModules(IModule module) {
        Module serverModule;
        block10: {
            try {
                if (module.getModuleType().getId().length() != 0) break block10;
                return null;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        if (module instanceof Module && (serverModule = (Module)module).getModuleFactory().getId().equals("oracle.eclipse.tools.coherence.garModuleFactory")) {
            return new IModule[]{module};
        }
        IModule[] parent = this.doGetParentModules(module);
        if (parent.length > 0) {
            return parent;
        }
        IProject project = module.getProject();
        if (project == null) {
            return new IModule[0];
        }
        IFacetedProject facetProject = ProjectFacetsManager.create((IProject)project);
        if (facetProject == null) {
            return new IModule[0];
        }
        if (facetProject.hasProjectFacet(FacetUtil.FACET_JST_EAR)) {
            return new IModule[]{module};
        }
        IModule[] ear = J2EEUtil.getEnterpriseApplications((IModule)module, null);
        if (ear != null && ear.length > 0) {
            return ear;
        }
        IModule[] ret = this.getRootModulesFromExtensions(module);
        if (ret != null) {
            return ret;
        }
        return new IModule[]{module};
    }

    protected IModule[] getRootModulesFromExtensions(IModule module) {
        return null;
    }

    private IModule[] doGetParentModules(IModule module) {
        IModule[] ears = ServerUtil.getModules((String)"jst.ear");
        ArrayList<IModule> list = new ArrayList<IModule>();
        int i = 0;
        while (i < ears.length) {
            IEnterpriseApplication ear = (IEnterpriseApplication)ears[i].loadAdapter(IEnterpriseApplication.class, null);
            IModule[] childs = ear.getModules();
            int j = 0;
            while (j < childs.length) {
                if (childs[j].equals(module)) {
                    list.add(ears[i]);
                    break;
                }
                ++j;
            }
            EARVirtualComponent earComp = (EARVirtualComponent)ComponentCore.createComponent((IProject)ears[i].getProject());
            if (earComp != null) {
                IVirtualReference[] iVirtualReferenceArray = earComp.getAllReferences();
                int n = iVirtualReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IVirtualReference ref = iVirtualReferenceArray[n2];
                    IProject p = ref.getReferencedComponent().getProject();
                    if (p.equals((Object)module.getProject())) {
                        list.add(ears[i]);
                        break;
                    }
                    ++n2;
                }
            }
            ++i;
        }
        return list.toArray(new IModule[list.size()]);
    }
}

