/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.weblogic.server.properties.KeystoreType;

public class ServerInfo {
    public static final int PORT_DISABLED = -1;
    private final String adminServerName;
    private final String domainName;
    private final String hostName;
    private final int portNumber;
    private final int httpsPort;
    private String confVersion;
    private List<ServerInfo> managedServers = new ArrayList<ServerInfo>();
    private Set<String> clusters = new HashSet<String>();
    private String clusterBelongsTo = null;
    private boolean isListenPortDisabled = false;
    private KeystoreType keystoreType = KeystoreType.DemoIdentityAndDemoTrust;
    private String customIdentityKeystore = null;
    private String customTrustKeystore = null;

    public KeystoreType getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String keystoreType) {
        if (keystoreType != null) {
            this.keystoreType = KeystoreType.valueOf(keystoreType);
        }
    }

    public String getCustomIdentityKeystore() {
        return this.customIdentityKeystore;
    }

    public void setCustomIdentityKeystore(String customIdentityKeystore) {
        this.customIdentityKeystore = customIdentityKeystore;
    }

    public String getCustomTrustKeystore() {
        return this.customTrustKeystore;
    }

    public void setCustomTrustKeystore(String customTrustKeystore) {
        this.customTrustKeystore = customTrustKeystore;
    }

    public boolean isListenPortDisabled() {
        return this.isListenPortDisabled;
    }

    public void setListenPortDisabled(boolean isListenPortDisabled) {
        this.isListenPortDisabled = isListenPortDisabled;
    }

    public ServerInfo(String serverName, String domainName, String hostName, int portNumber, int httpsPort, String confVersion) {
        this.adminServerName = serverName;
        this.domainName = domainName;
        this.hostName = hostName;
        this.portNumber = portNumber;
        this.httpsPort = httpsPort;
        this.confVersion = confVersion;
    }

    public ServerInfo(String hostName, int portNumber) {
        this.adminServerName = null;
        this.domainName = null;
        this.httpsPort = -1;
        this.confVersion = null;
        this.hostName = hostName;
        this.portNumber = portNumber;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public String getServerName() {
        return this.adminServerName;
    }

    public String getConfigVersion() {
        return this.confVersion;
    }

    public void setConfigVersion(String version) {
        this.confVersion = version;
    }

    public List<String> getServers() {
        ArrayList<String> serverNames = new ArrayList<String>();
        for (ServerInfo info : this.managedServers) {
            serverNames.add(info.getServerName());
        }
        return serverNames;
    }

    public List<ServerInfo> getManagedServerList() {
        return this.managedServers;
    }

    public void setManagedServers(List<ServerInfo> servers) {
        this.managedServers = servers;
    }

    public Set<String> getClusterNames() {
        return this.clusters;
    }

    public void setClusterNames(Set<String> clusters) {
        this.clusters = clusters;
    }

    public String getCluster() {
        return this.clusterBelongsTo;
    }

    public void setCluster(String s) {
        this.clusterBelongsTo = s;
    }
}

