/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class CorePlugin {
    public static final int STATUS_CODE_UNKNOWN = 0;
    public static final int STATUS_CODE_OK = 1000;
    public static final int STATUS_CODE_INFO = 2000;
    public static final int STATUS_CODE_WARN = 3000;
    public static final int STATUS_CODE_ERROR = 4000;
    public static final String DEFAULT_START_SCRIPT = "startWebLogic";
    public static final IStatus STATUS_OK = new Status(0, "oracle.eclipse.tools.weblogic", 1000, "", null);
    public static final boolean IS_WINDOWS = "win32".equals(Platform.getOS());
    public static final boolean IS_UNIX = "linux".equals(Platform.getOS()) || "macosx".equals(Platform.getOS()) || "solaris".equals(Platform.getOS()) || "aix".equals(Platform.getOS()) || "hpux".equals(Platform.getOS());
    public static final boolean IS_MACOSX = "macosx".equals(Platform.getOS());
    private static final String RESOURCES = "oracle.eclipse.tools.weblogic.server.CoreResources";
    public static final List<String> SHELLSCRIPT_WINDOWS_EXT = Collections.unmodifiableList(Arrays.asList("cmd", "bat"));
    public static final List<String> SHELLSCRIPT_UNIX_EXT = Collections.unmodifiableList(Arrays.asList("sh"));
    private static String filterExtension = CorePlugin.initScriptExtensions();
    private static ResourceBundle resourceBundle;
    private static LevelLog log;

    static {
        try {
            resourceBundle = ResourceBundle.getBundle(RESOURCES);
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundle = null;
        }
    }

    public static ILog getLog() {
        return Platform.getLog((Bundle)WlsCorePlugin.getPluginBundle());
    }

    public static LevelLog getLevelLog() {
        if (log == null) {
            log = new LevelLog(CorePlugin.getLog());
        }
        return log;
    }

    public static void log(Exception e) {
        String msg = String.valueOf(e.getMessage());
        CorePlugin.log((IStatus)new Status(4, "oracle.eclipse.tools.weblogic", 0, msg, (Throwable)e));
    }

    public static void log(IStatus status) {
        CorePlugin.getLog().log(status);
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = CorePlugin.getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getString(String key, Object ... args) {
        ResourceBundle bundle = CorePlugin.getResourceBundle();
        try {
            if (bundle == null) {
                return "%" + key + "%";
            }
            if (args == null || args.length == 0) {
                return bundle.getString(key);
            }
            return String.format(bundle.getString(key), args);
        }
        catch (MissingResourceException missingResourceException) {
            return "%" + key + "%";
        }
    }

    public static MultiStatus createMultiStatus(String msg, IStatus ... status) {
        return CorePlugin.createMultiStatus(msg, null, 0, status);
    }

    public static MultiStatus createMultiStatus(String msg, Throwable t, int code, IStatus ... status) {
        if (status == null) {
            status = new IStatus[]{};
        }
        return new MultiStatus("oracle.eclipse.tools.weblogic", code, status, msg, t);
    }

    public static IStatus createErrorStatus(String msg, Throwable e) {
        return CorePlugin.createErrorStatus(msg, e, 4000);
    }

    public static IStatus createErrorStatus(String msg, Throwable e, int code) {
        return new Status(4, "oracle.eclipse.tools.weblogic", code, String.valueOf(msg), e);
    }

    public static IStatus createErrorStatus(String msg) {
        return CorePlugin.createErrorStatus(msg, null, 4000);
    }

    public static IStatus createWarnStatus(String msg) {
        return CorePlugin.createWarnStatus(msg, null, 3000);
    }

    public static IStatus createWarnStatus(String msg, Throwable e) {
        return CorePlugin.createWarnStatus(msg, e, 3000);
    }

    public static IStatus createWarnStatus(String msg, Throwable e, int code) {
        return new Status(2, "oracle.eclipse.tools.weblogic", code, String.valueOf(msg), e);
    }

    public static IStatus createInfoStatus(String msg) {
        return CorePlugin.createInfoStatus(msg, 2000);
    }

    public static IStatus createInfoStatus(String msg, int code) {
        return new Status(1, "oracle.eclipse.tools.weblogic", code, String.valueOf(msg), null);
    }

    public static IStatus createOkStatus(String msg) {
        return CorePlugin.createOkStatus(msg, 1000);
    }

    public static IStatus createOkStatus(String msg, int code) {
        if (msg == null || msg.length() == 0) {
            return STATUS_OK;
        }
        return new Status(0, "oracle.eclipse.tools.weblogic", code, String.valueOf(msg), null);
    }

    public static ResourceBundle getResourceBundle() {
        try {
            if (resourceBundle == null) {
                resourceBundle = ResourceBundle.getBundle(RESOURCES);
            }
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundle = null;
        }
        return resourceBundle;
    }

    private static String initScriptExtensions() {
        if (IS_WINDOWS) {
            filterExtension = "cmd";
            return "cmd";
        }
        filterExtension = "sh";
        return "sh";
    }

    public static String getScriptExtension() {
        return filterExtension;
    }

    public static class LevelLog
    implements ILog {
        public static final int LOG_LEVEL_DEBUG = 0;
        public static final int LOG_LEVEL_INFO = 1;
        public static final int LOG_LEVEL_WARNING = 2;
        public static final int LOG_LEVEL_ERROR = 3;
        private int level = 0;
        private ILog log;

        LevelLog(ILog log) {
            this.log = log;
        }

        public void addLogListener(ILogListener listener) {
            this.log.addLogListener(listener);
        }

        public Bundle getBundle() {
            return this.log.getBundle();
        }

        public void log(IStatus status) {
            this.log.log(status);
        }

        public void logDebug(IStatus status) {
            if (this.isDebugEnabled()) {
                this.log.log(status);
            }
        }

        public void logInfo(IStatus status) {
            if (this.isInfoEnabled()) {
                this.log.log(status);
            }
        }

        public void logDebug(String msg) {
            if (this.isDebugEnabled()) {
                this.log.log(CorePlugin.createInfoStatus(msg));
            }
        }

        public void logInfo(String msg) {
            if (this.isInfoEnabled()) {
                this.log.log(CorePlugin.createInfoStatus(msg));
            }
        }

        public void removeLogListener(ILogListener listener) {
            this.log.removeLogListener(listener);
        }

        public boolean isDebugEnabled() {
            return this.level == 0;
        }

        public boolean isInfoEnabled() {
            return this.isDebugEnabled() || this.level == 1;
        }
    }
}

