/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.operations;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import oracle.eclipse.tools.common.util.fileio.EclipseFileUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.IWlsAdapterListener;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerRuntime;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IRuntime;
import org.osgi.framework.Bundle;

public class CreateDomainOperation {
    private static final String CREATE_DOMAIN_SCRIPT = "wlst.scripts/CreateDomain.py";
    private IRuntime wlsRunTime;
    private IPath wlhome;
    private IPath domainDirectory;

    public IPath getWebLogicHome() {
        return this.wlhome;
    }

    public void setWebLogicRuntime(IRuntime wlsRunTime) {
        this.wlsRunTime = wlsRunTime;
        this.wlhome = wlsRunTime.getLocation();
    }

    public IPath getDomainDirectory() {
        return this.domainDirectory;
    }

    public void setDomainDirectory(IPath domainDirectory) {
        this.domainDirectory = domainDirectory;
    }

    public void execute() throws Exception {
        InputStreamReader scriptFileReader = new InputStreamReader(FileLocator.openStream((Bundle)WlsCorePlugin.getPluginBundle(), (IPath)new Path(CREATE_DOMAIN_SCRIPT), (boolean)false), StandardCharsets.UTF_8);
        String scriptFileContent = null;
        try {
            StringBuilder buffer = new StringBuilder();
            char[] chars = new char[1024];
            int count = scriptFileReader.read(chars);
            while (count != -1) {
                buffer.append(chars, 0, count);
                count = scriptFileReader.read(chars);
            }
            scriptFileContent = buffer.toString();
        }
        catch (Throwable throwable) {
            try {
                ((Reader)scriptFileReader).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((Reader)scriptFileReader).close();
        }
        catch (IOException iOException) {}
        scriptFileContent = scriptFileContent.replace("@domainTemplateJar@", this.getDomainTemplateLocation().toPortableString());
        scriptFileContent = scriptFileContent.replace("@domainDirectory@", this.domainDirectory.toPortableString());
        File domainDirectory = this.domainDirectory.toFile();
        File parentDirectory = domainDirectory.getParentFile();
        String domainDirectoryLocalName = this.domainDirectory.lastSegment();
        File creationScriptFile = new File(parentDirectory, String.valueOf(domainDirectoryLocalName) + ".py");
        EclipseFileUtil.mkdirs((File)domainDirectory);
        OutputStreamWriter scriptFileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(creationScriptFile), StandardCharsets.UTF_8);
        try {
            scriptFileWriter.write(scriptFileContent);
        }
        catch (Throwable throwable) {
            try {
                ((Writer)scriptFileWriter).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((Writer)scriptFileWriter).close();
        }
        catch (IOException iOException) {}
        String[] envp = null;
        WeblogicServerRuntime rt = (WeblogicServerRuntime)this.wlsRunTime.loadAdapter(WeblogicServerRuntime.class, null);
        if (rt.getDefaultJavaVmLocation() == null) {
            envp = new String[2];
            String mwHome = WeblogicServerRuntime.getProperty(this.wlsRunTime, "MW_HOME");
            envp[0] = "MW_HOME=" + mwHome;
            envp[1] = "JAVA_HOME=" + rt.getJavaVmLocation().toPortableString();
        }
        String[] command = null;
        command = CorePlugin.IS_MACOSX ? new String[]{"sh", this.getWlstCommandLocation().toOSString(), creationScriptFile.getAbsolutePath()} : new String[]{this.getWlstCommandLocation().toOSString(), creationScriptFile.getAbsolutePath()};
        Process p = Runtime.getRuntime().exec(command, envp, this.wlhome.append("common/bin/").toFile());
        IWlsAdapterListener adapter = WlsRuntimeUtil.getWlsAdapter();
        if (adapter != null) {
            adapter.captureScriptStart(p, new String[]{"Creating WebLogic Domain..."}, "UTF-8");
        }
        InputStream pInputStream = p.getInputStream();
        try {
            BufferedReader pReader = new BufferedReader(new InputStreamReader(pInputStream, Charset.defaultCharset()));
            String line = pReader.readLine();
            while (line != null) {
                System.out.println(line);
                line = pReader.readLine();
            }
        }
        catch (Throwable throwable) {
            try {
                pInputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            pInputStream.close();
        }
        catch (IOException iOException) {}
    }

    private IPath getDomainTemplateLocation() {
        WebLogicServerVersion version = WebLogicServerVersion.detect(this.wlsRunTime);
        if (version.compareTo(WebLogicServerVersion.VERSION_12_1_2) > 0) {
            return this.wlhome.append("common/templates/wls/wls.jar");
        }
        return this.wlhome.append("common/templates/domains/wls.jar");
    }

    private IPath getWlstCommandLocation() {
        String extension = Platform.getOS().equals("win32") ? "cmd" : "sh";
        return this.wlhome.append("common/bin/wlst." + extension);
    }
}

