/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.migration.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public final class ProjectReferenceUtil {
    public static Set<IProject> getRelatedProjects(IProject projectToMigrate) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        HashSet<IProject> projectsToMigrate = new HashSet<IProject>();
        IProject[] allProjects = workspace.getRoot().getProjects();
        ProjectReferenceUtil.addProjectToMigrate(projectToMigrate, projectsToMigrate);
        int numProjectsToMigratePreviousIteration = 0;
        do {
            numProjectsToMigratePreviousIteration = projectsToMigrate.size();
            IProject[] iProjectArray = allProjects;
            int n = allProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IVirtualReference[] refs;
                IVirtualComponent virtualComponent;
                IProject project = iProjectArray[n2];
                if (!projectsToMigrate.contains(project) && (virtualComponent = ComponentCore.createComponent((IProject)project)) != null && (refs = virtualComponent.getReferences()) != null) {
                    IVirtualReference[] iVirtualReferenceArray = refs;
                    int n3 = refs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IProject referencedProject;
                        IVirtualReference ref = iVirtualReferenceArray[n4];
                        IVirtualComponent referencedComponent = ref.getReferencedComponent();
                        if (referencedComponent != null && !referencedComponent.isBinary() && projectsToMigrate.contains(referencedProject = referencedComponent.getProject())) {
                            ProjectReferenceUtil.addProjectToMigrate(project, projectsToMigrate);
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        } while (numProjectsToMigratePreviousIteration < projectsToMigrate.size());
        return projectsToMigrate;
    }

    private static void addProjectToMigrate(IProject projectToMigrate, Set<IProject> projectsToMigrate) {
        if (!projectsToMigrate.contains(projectToMigrate)) {
            projectsToMigrate.add(projectToMigrate);
            IVirtualComponent virtualComponent = ComponentCore.createComponent((IProject)projectToMigrate);
            if (virtualComponent == null) {
                return;
            }
            IVirtualReference[] projectRefs = virtualComponent.getReferences();
            if (projectRefs != null) {
                IVirtualReference[] iVirtualReferenceArray = projectRefs;
                int n = projectRefs.length;
                int n2 = 0;
                while (n2 < n) {
                    IVirtualReference ref = iVirtualReferenceArray[n2];
                    IVirtualComponent referencedComponent = ref.getReferencedComponent();
                    if (referencedComponent != null && !referencedComponent.isBinary()) {
                        IProject referencedProject = referencedComponent.getProject();
                        ProjectReferenceUtil.addProjectToMigrate(referencedProject, projectsToMigrate);
                    }
                    ++n2;
                }
            }
        }
    }
}

