/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.migration.internal;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public final class FacetMigrationAction {
    private List<ActionType> facetActions = new ArrayList<ActionType>();
    private Expression enablementCondition = null;
    private String pluginId = null;
    private static final String EXPR_VAR_PROJECT_FACETS = "projectFacets";

    FacetMigrationAction() {
    }

    public boolean isEnabledFor(IProject project) {
        IFacetedProject facetedProject;
        EvaluationContext evalContext;
        block4: {
            if (this.enablementCondition == null) {
                return true;
            }
            evalContext = new EvaluationContext(null, (Object)project);
            try {
                facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject != null) break block4;
                return false;
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (CoreException)e);
                return false;
            }
        }
        evalContext.addVariable(EXPR_VAR_PROJECT_FACETS, (Object)facetedProject.getProjectFacets());
        evalContext.setAllowPluginActivation(true);
        EvaluationResult evalResult = this.enablementCondition.evaluate((IEvaluationContext)evalContext);
        return evalResult == EvaluationResult.TRUE;
    }

    public List<ActionType> getFacetActions() {
        return this.facetActions;
    }

    public void addFacetAction(ActionType facetAction) {
        this.facetActions.add(facetAction);
    }

    public Expression getEnablementCondition() {
        return this.enablementCondition;
    }

    void setEnablementCondition(Expression enablementCondition) {
        this.enablementCondition = enablementCondition;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public static final class ActionType {
        private final IProjectFacet facet;
        private final IProjectFacetVersion facetVersion;
        private final IFacetedProject.Action.Type actionType;

        ActionType(IProjectFacet facet, IProjectFacetVersion facetVersion, IFacetedProject.Action.Type actionType) {
            this.facet = facet;
            this.facetVersion = facetVersion;
            this.actionType = actionType;
        }

        public IFacetedProject.Action.Type getActionType() {
            return this.actionType;
        }

        public IProjectFacet getFacet() {
            return this.facet;
        }

        public IProjectFacetVersion getFacetVersion() {
            return this.facetVersion;
        }
    }
}

