/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.migration;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.migration.internal.FacetMigrationAction;
import oracle.eclipse.tools.weblogic.migration.internal.FacetMigrationActionExtensionReader;
import oracle.eclipse.tools.weblogic.migration.internal.ProjectReferenceUtil;
import oracle.eclipse.tools.weblogic.server.internal.util.ModuleUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IActionDefinition;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;

public final class FacetMigrator {
    private static final int SET_RUNTIME_TICKS = 1;
    private static final int APPLY_FACETS_TICKS = 2;
    private static final int VALIDATE_TICKS = 1;
    private static final int SET_SERVER_TICKS = 1;
    private static final int TOTAL_MODIFICATION_TICKS = 4;
    private FacetMigrationActionExtensionReader _extensionReader = new FacetMigrationActionExtensionReader();

    public Set<IProject> getRelatedProjects(IProject projectToMigrate) {
        return ProjectReferenceUtil.getRelatedProjects(projectToMigrate);
    }

    public IStatus migrateProjects(Set<IProject> projects, IServer wlsServer, IProgressMonitor monitor) throws CoreException {
        int migrateRuntimeWork = this.calculateWorkLoad(projects);
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)Resources.migrateRutimeTaskName, (int)(migrateRuntimeWork + (1 + projects.size())));
        try {
            IRuntime wlsRuntime = wlsServer.getRuntime();
            IStatus status = this.migrateProjects(projects, wlsRuntime, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)migrateRuntimeWork));
            if (status.getSeverity() != 4 && status.getSeverity() != 8) {
                int n;
                int n2;
                IModule[] iModuleArray;
                HashSet<IModule> rootMods = new HashSet<IModule>();
                block3: for (IProject project : projects) {
                    IModule[] modules;
                    if (oracle.eclipse.tools.common.wtp.core.ServerUtil.isAssociatedWithServer((IServer)wlsServer, (IProject)project) || (modules = ServerUtil.getModules((IProject)project)) == null || modules.length <= 0) continue;
                    iModuleArray = modules;
                    n2 = modules.length;
                    n = 0;
                    while (n < n2) {
                        IModule module = iModuleArray[n];
                        if (ModuleUtil.isUtilityModule(module)) continue block3;
                        IModule[] parents = wlsServer.getRootModules(module, monitor);
                        if (parents != null && parents.length > 0) {
                            rootMods.addAll(Arrays.asList(parents));
                        } else {
                            rootMods.add(module);
                        }
                        ++n;
                    }
                }
                Iterator moduleIter = rootMods.iterator();
                IModule[] deployedMods = wlsServer.getModules();
                if (deployedMods != null && deployedMods.length > 0) {
                    block5: while (moduleIter.hasNext()) {
                        IModule mod = (IModule)moduleIter.next();
                        iModuleArray = deployedMods;
                        n2 = deployedMods.length;
                        n = 0;
                        while (n < n2) {
                            IModule deployedMod = iModuleArray[n];
                            if (mod.equals(deployedMod)) {
                                moduleIter.remove();
                                continue block5;
                            }
                            ++n;
                        }
                    }
                }
                if (rootMods != null && rootMods.size() != 0) {
                    IServerWorkingCopy wc = wlsServer.createWorkingCopy();
                    wc.modifyModules(rootMods.toArray(new IModule[rootMods.size()]), null, monitor);
                    wc.save(false, monitor);
                    if (wlsServer.getServerState() == 2) {
                        wlsServer.publish(3, monitor);
                    }
                }
                ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
            }
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    public IStatus migrateProjects(Set<IProject> projects, IRuntime wlsRuntime, IProgressMonitor monitor) throws CoreException {
        MigrationRunnable mr = new MigrationRunnable(projects, wlsRuntime);
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ws.run((IWorkspaceRunnable)mr, (ISchedulingRule)ws.getRoot(), 1, monitor);
        return mr.getStatus();
    }

    private IStatus migrateProjectsInternal(Set<IProject> projects, IRuntime wlsRuntime, IProgressMonitor monitor) throws CoreException {
        int totalWork = this.calculateWorkLoad(projects);
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)Resources.migrateRutimeTaskName, (int)totalWork);
        try {
            Collection<FacetMigrationAction> actions;
            MultiStatus status = new MultiStatus("oracle.eclipse.tools.weblogic", 0, "", null);
            HashMap<IFacetedProject, HashSet<IFacetedProject.Action>> facetedProjectActionMap = new HashMap<IFacetedProject, HashSet<IFacetedProject.Action>>();
            if (wlsRuntime == null) {
                throw new IllegalArgumentException(Resources.invalidRuntime);
            }
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime newRuntime = RuntimeBridgeUtil.bridge((IRuntime)wlsRuntime);
            for (IProject project : projects) {
                IFacetedProject facetedProject = null;
                try {
                    facetedProject = ProjectFacetsManager.create((IProject)project);
                }
                catch (CoreException ce) {
                    status.merge(ce.getStatus());
                    LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (CoreException)ce);
                }
                if (facetedProject == null) {
                    ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                    continue;
                }
                HashSet<IFacetedProject.Action> actionSet = new HashSet<IFacetedProject.Action>();
                facetedProjectActionMap.put(facetedProject, actionSet);
                actions = this._extensionReader.getActionsFor(project, wlsRuntime);
                for (FacetMigrationAction facetMigrationAction : actions) {
                    for (FacetMigrationAction.ActionType facetAction : facetMigrationAction.getFacetActions()) {
                        IFacetedProject.Action action = this.prepareAction(facetedProject, facetAction, status);
                        if (action == null) continue;
                        actionSet.add(action);
                    }
                }
                HashSet<IProjectFacetVersion> newFacets = new HashSet<IProjectFacetVersion>();
                newFacets.addAll(facetedProject.getProjectFacets());
                this.applyFacetActions(newFacets, actionSet);
                if (actionSet.size() > 0) {
                    IStatus checkStatus = ProjectFacetsManager.check((Set)facetedProject.getProjectFacets(), actionSet);
                    status.merge(checkStatus);
                }
                for (IProjectFacetVersion fv : newFacets) {
                    if (newRuntime.supports(fv)) continue;
                    String message = NLS.bind((String)Resources.runtimeDoesNotSupport, (Object)newRuntime.getName(), (Object)fv.toString());
                    status.merge((IStatus)new Status(4, "oracle.eclipse.tools.weblogic", message));
                }
                ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
            }
            if (status.getSeverity() != 4 && status.getSeverity() != 8) {
                Set facetedProjectKeyset = facetedProjectActionMap.keySet();
                int skippedTicks = (projects.size() - facetedProjectKeyset.size()) * 4;
                ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)skippedTicks);
                for (IFacetedProject actionableFacetedProject : facetedProjectKeyset) {
                    actionableFacetedProject.setTargetedRuntimes(Collections.emptySet(), ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
                    actions = (Set)facetedProjectActionMap.get(actionableFacetedProject);
                    if (actions != null && actions.size() > 0) {
                        actionableFacetedProject.modify(actions, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)2));
                    }
                    Set<org.eclipse.wst.common.project.facet.core.runtime.IRuntime> runtimes = Collections.singleton(newRuntime);
                    actionableFacetedProject.setTargetedRuntimes(runtimes, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
                }
            } else {
                LoggingService.logWarning((String)"oracle.eclipse.tools.weblogic", (String)Resources.abortedMigration);
            }
            MultiStatus multiStatus = status;
            return multiStatus;
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    private IFacetedProject.Action prepareAction(IFacetedProject facetedProject, FacetMigrationAction.ActionType facetAction, MultiStatus status) {
        IProjectFacetVersion facetVersion;
        block4: {
            facetVersion = null;
            try {
                if (facetAction.getActionType() != IFacetedProject.Action.Type.UNINSTALL) break block4;
                facetVersion = facetedProject.getInstalledVersion(facetAction.getFacet());
                if (facetVersion == null) {
                    String msg = Resources.bind((String)Resources.facetRemoveFailed, (Object)facetedProject.getProject().getName(), (Object)facetAction.getFacet().getLabel());
                    status.add((IStatus)new Status(4, "oracle.eclipse.tools.weblogic", 0, msg, null));
                    LoggingService.logError((String)"oracle.eclipse.tools.weblogic", (String)msg);
                    return null;
                }
            }
            catch (IllegalArgumentException iae) {
                status.add((IStatus)new Status(4, "oracle.eclipse.tools.weblogic", 0, iae.getMessage(), (Throwable)iae));
                LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (Throwable)iae);
                return null;
            }
        }
        facetVersion = facetAction.getFacetVersion();
        Object actionObject = this.createActionConfig(facetedProject, facetVersion, facetAction, status);
        return new IFacetedProject.Action(facetAction.getActionType(), facetVersion, actionObject);
    }

    private Object createActionConfig(IFacetedProject facetedProject, IProjectFacetVersion facetVersion, FacetMigrationAction.ActionType facetAction, MultiStatus status) {
        Object actionObject = null;
        try {
            IActionDefinition actionDef = facetVersion.getActionDefinition(facetedProject.getProjectFacets(), facetAction.getActionType());
            actionObject = actionDef.createConfigObject(facetVersion, facetedProject.getProject().getName());
        }
        catch (CoreException ce) {
            status.merge(ce.getStatus());
            LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (CoreException)ce);
            return null;
        }
        return actionObject;
    }

    private void applyFacetActions(Set<IProjectFacetVersion> facets, Set<IFacetedProject.Action> actions) {
        for (IFacetedProject.Action action : actions) {
            IFacetedProject.Action.Type type = action.getType();
            IProjectFacetVersion fv = action.getProjectFacetVersion();
            if (type == IFacetedProject.Action.Type.INSTALL) {
                facets.add(fv);
                continue;
            }
            if (type == IFacetedProject.Action.Type.UNINSTALL) {
                facets.remove(fv);
                continue;
            }
            if (type != IFacetedProject.Action.Type.VERSION_CHANGE) continue;
            Iterator<IProjectFacetVersion> itr = facets.iterator();
            while (itr.hasNext()) {
                IProjectFacetVersion x = itr.next();
                if (x.getProjectFacet() != fv.getProjectFacet()) continue;
                itr.remove();
                break;
            }
            facets.add(fv);
        }
    }

    private int calculateWorkLoad(Set<IProject> projects) {
        return projects.size() * 5;
    }

    class MigrationRunnable
    implements IWorkspaceRunnable {
        private IStatus status = null;
        private Set<IProject> projects = null;
        private IRuntime wlsRuntime = null;

        public IStatus getStatus() {
            return this.status;
        }

        MigrationRunnable(Set<IProject> projects, IRuntime wlsRuntime) {
            this.projects = projects;
            this.wlsRuntime = wlsRuntime;
        }

        public void run(IProgressMonitor mon) throws CoreException {
            this.status = FacetMigrator.this.migrateProjectsInternal(this.projects, this.wlsRuntime, mon);
        }
    }

    public static final class Resources
    extends NLS {
        public static String facetRemoveFailed;
        public static String invalidRuntime;
        public static String noFacetedProject;
        public static String beginMigration;
        public static String clearingRuntimes;
        public static String performFacetActions;
        public static String settingRuntime;
        public static String finishedMigration;
        public static String abortedMigration;
        public static String preparingAction;
        public static String actionConfigvalidationWarn;
        public static String actionConfigvalidationError;
        public static String migrateRutimeTaskName;
        public static String runtimeDoesNotSupport;

        static {
            Resources.initializeMessages((String)FacetMigrator.class.getName(), Resources.class);
        }
    }
}

