/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.jsf.provider.internal;

import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.wtp.webxml.WebXmlUpdater;
import oracle.eclipse.tools.weblogic.j2eelib.provider.SharedLibraryProviderUninstallOperationConfig;
import oracle.eclipse.tools.weblogic.j2eelib.provider.internal.SharedLibraryProviderUninstallOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;

public class JsfSharedLibraryProviderUninstallOperation
extends SharedLibraryProviderUninstallOperation {
    @Override
    public void execute(LibraryProviderOperationConfig config, IProgressMonitor monitor) throws CoreException {
        try {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)"", (int)2);
            super.execute(config, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
            SharedLibraryProviderUninstallOperationConfig cfg = (SharedLibraryProviderUninstallOperationConfig)config;
            IProject project = config.getFacetedProject().getProject();
            this.updateWebXml(cfg, project, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    private void updateWebXml(SharedLibraryProviderUninstallOperationConfig libConfig, IProject project, IProgressMonitor monitor) {
        String libraryName = libConfig.getLibraryName();
        if (libraryName.equalsIgnoreCase("jsf-myfaces")) {
            this.updateWebXmlForMyfacesUninstall(project, monitor);
        } else if (libraryName.equalsIgnoreCase("jsf-ri")) {
            this.updateWebXmlForSunRiUninstall(project, monitor);
        }
    }

    private void updateWebXmlForMyfacesUninstall(IProject project, IProgressMonitor monitor) {
        WebXmlUpdater updater = new WebXmlUpdater(project, monitor);
        updater.removeContextParam("javax.servlet.jsp.jstl.fmt.localizationContext", "resources.application");
        updater.removeContextParam("javax.faces.STATE_SAVING_METHOD", "client");
        updater.removeContextParam("org.apache.myfaces.ALLOW_JAVASCRIPT", "true");
        updater.removeContextParam("org.apache.myfaces.PRETTY_HTML", "true");
        updater.removeContextParam("org.apache.myfaces.DETECT_JAVASCRIPT", "false");
        updater.removeContextParam("org.apache.myfaces.AUTO_SCROLL", "true");
        updater.removeListener("org.apache.myfaces.webapp.StartupServletContextListener");
    }

    private void updateWebXmlForSunRiUninstall(IProject project, IProgressMonitor monitor) {
        WebXmlUpdater updater = new WebXmlUpdater(project, monitor);
        updater.removeContextParam("javax.faces.STATE_SAVING_METHOD", "client");
        updater.removeContextParam("javax.servlet.jsp.jstl.fmt.localizationContext", "resources.application");
        updater.removeListener("com.sun.faces.config.ConfigureListener");
        updater.removeServlet("javax.faces.webapp.FacesServlet");
    }
}

