/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.jpa;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.common.util.fileio.ManifestUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerInstall;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;

public final class WebLogicServerJpaComponent {
    public static final String ID = "oracle.weblogic.jpa";
    public static final IRuntimeComponentType TYPE = RuntimeManager.getRuntimeComponentType((String)"oracle.weblogic.jpa");
    public static final IRuntimeComponentVersion VERSION_1_0 = TYPE.getVersion("1.0");
    public static final IRuntimeComponentVersion VERSION_2_0 = TYPE.getVersion("2.0");
    public static final String JPA_2_MODULE_A = "javax.persistence_1.0.0.0_2-";
    public static final String JPA_2_MODULE_A1 = "javax.persistence_1.1.0.0_2-";
    public static final String JPA_2_MODULE_B = "com.oracle.jpa2support_1.0.0.0_2-";
    public static final String JPA_2_MODULE_VER_12 = "javax.persistence_2.0.0.0_2-";
    private static List<DetectionResult> DETECTION_CACHE = new ArrayList<DetectionResult>();
    private static final long DETECTION_CACHE_TIMEOUT = 1000L;

    public static IRuntimeComponentVersion detect(WebLogicServerInstall install) {
        return WebLogicServerJpaComponent.detect(install, false);
    }

    public static IRuntimeComponentVersion detect(WebLogicServerInstall install, boolean force) {
        DetectionResult result = null;
        Iterator<DetectionResult> itr = DETECTION_CACHE.iterator();
        while (itr.hasNext()) {
            DetectionResult r = itr.next();
            if (!r.matches(install)) continue;
            if (force || r.stale()) {
                itr.remove();
                break;
            }
            result = r;
            break;
        }
        if (result == null) {
            WebLogicServerVersion version = install.getVersion();
            IRuntimeComponentVersion rcv = null;
            if (version != null && version.compareTo(WebLogicServerVersion.VERSION_9_2) >= 0) {
                if (version.compareTo(WebLogicServerVersion.VERSION_10_3_4) >= 0) {
                    boolean[] res = new boolean[2];
                    WebLogicServerJpaComponent.detect(new File(install.getLocation(), "server/lib/weblogic.jar"), res);
                    File patchProfileJarLocation = install.getPatchProfileJarLocation();
                    if (patchProfileJarLocation != null) {
                        WebLogicServerJpaComponent.detect(patchProfileJarLocation, res);
                    }
                    rcv = res[0] && res[1] ? VERSION_2_0 : VERSION_1_0;
                } else {
                    rcv = VERSION_1_0;
                }
            }
            result = new DetectionResult(install.getLocation(), install.getPatchProfile(), rcv);
            DETECTION_CACHE.add(result);
        }
        return result.version;
    }

    private static void detect(File jar, boolean[] result) {
        String name = jar.getName();
        if (name.startsWith(JPA_2_MODULE_A) || name.startsWith(JPA_2_MODULE_A1)) {
            result[0] = true;
        } else if (name.startsWith(JPA_2_MODULE_B)) {
            result[1] = true;
        } else if (name.startsWith(JPA_2_MODULE_VER_12)) {
            result[0] = true;
            result[1] = true;
        }
        if (result[0] && result[1]) {
            return;
        }
        try {
            for (File refjar : ManifestUtil.readManifestClasspath((File)jar)) {
                WebLogicServerJpaComponent.detect(refjar, result);
                if (!result[0] || !result[1]) continue;
                return;
            }
        }
        catch (IOException e) {
            WlsCorePlugin.logException(e);
        }
    }

    private static final class DetectionResult {
        public final File wlhome;
        public final String patchProfile;
        public final IRuntimeComponentVersion version;
        public final long timestamp;

        public DetectionResult(File wlhome, String patchProfile, IRuntimeComponentVersion version) {
            this.wlhome = wlhome;
            this.patchProfile = patchProfile;
            this.version = version;
            this.timestamp = System.currentTimeMillis();
        }

        public boolean matches(WebLogicServerInstall install) {
            return this.wlhome.equals(install.getLocation()) && (this.patchProfile == install.getPatchProfile() || this.patchProfile != null && this.patchProfile.equals(install.getPatchProfile()));
        }

        public boolean stale() {
            return System.currentTimeMillis() - this.timestamp > 1000L;
        }
    }
}

