/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.AbstractProblem;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.IProblem;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;

public final class UnableToResolveLibraryProblem
extends AbstractProblem {
    private static final String PROBLEM_TYPE_CLASSPATH = "UnableToResolveLibraryProblem_Classpath";
    private static final String PROBLEM_TYPE_DESCRIPTOR = "UnableToResolveLibraryProblem_Descriptor";
    private static final Set<String> PROBLEM_TYPES;
    private final String problemType;
    private final String problemId;
    private final String message;
    private final LibraryModuleRef libref;

    static {
        HashSet<String> problemTypes = new HashSet<String>();
        problemTypes.add(PROBLEM_TYPE_CLASSPATH);
        problemTypes.add(PROBLEM_TYPE_DESCRIPTOR);
        PROBLEM_TYPES = Collections.unmodifiableSet(problemTypes);
    }

    private UnableToResolveLibraryProblem(IProject project, LibraryModuleRef libref, String problemType) {
        super(project);
        this.problemType = problemType;
        StringBuilder buf = new StringBuilder();
        buf.append(this.getProblemType());
        buf.append('/');
        buf.append(UnableToResolveLibraryProblem.convertLibraryModuleRefToString(libref));
        this.problemId = buf.toString();
        this.message = this.problemType.equals(PROBLEM_TYPE_CLASSPATH) ? Resources.bind((String)Resources.messageForClasspath, (Object)libref.getName()) : Resources.bind((String)Resources.messageForDescriptor, (Object)libref.getName());
        this.libref = libref;
    }

    public UnableToResolveLibraryProblem(IProject project, LibraryModuleRef libref, boolean isClasspathProblem) {
        this(project, libref, isClasspathProblem ? PROBLEM_TYPE_CLASSPATH : PROBLEM_TYPE_DESCRIPTOR);
    }

    public UnableToResolveLibraryProblem(IMarker marker) {
        this(marker.getResource().getProject(), UnableToResolveLibraryProblem.getLibraryModuleRefFromMarker(marker), UnableToResolveLibraryProblem.getProblemTypeFromMarker(marker));
    }

    public static IProblem convertMarker(IMarker marker) {
        String problemType = marker.getAttribute("problem-type", null);
        if (problemType != null && (problemType.equals(PROBLEM_TYPE_CLASSPATH) || problemType.equals(PROBLEM_TYPE_DESCRIPTOR))) {
            return new UnableToResolveLibraryProblem(marker);
        }
        return null;
    }

    public static Set<String> getProblemTypes() {
        return PROBLEM_TYPES;
    }

    @Override
    public String getProblemType() {
        return this.problemType;
    }

    @Override
    public String getProblemId() {
        return this.problemId;
    }

    @Override
    public int getSeverity() {
        return 2;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return Collections.singletonMap("library-ref", this.libref);
    }

    public LibraryModuleRef getLibraryModuleRef() {
        return this.libref;
    }

    public boolean isClasspathProblem() {
        return this.problemType.equals(PROBLEM_TYPE_CLASSPATH);
    }

    private static final class Resources
    extends NLS {
        public static String messageForClasspath;
        public static String messageForDescriptor;

        static {
            Resources.initializeMessages((String)UnableToResolveLibraryProblem.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

