/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems;

import java.util.Collections;
import java.util.Map;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.AbstractProblem;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.IProblem;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;

public final class MustBePartOfEarToUseLibProblem
extends AbstractProblem {
    private static final String PROBLEM_TYPE = "MustBePartOfEarToUseLibProblem";
    private final String id;
    private final String message;
    private final LibraryModuleRef libref;

    public MustBePartOfEarToUseLibProblem(IProject project, LibraryModuleRef libref) {
        super(project);
        this.libref = libref;
        StringBuilder buf = new StringBuilder();
        buf.append(PROBLEM_TYPE);
        buf.append('/');
        buf.append(this.libref.getName());
        this.id = buf.toString();
        this.message = Resources.bind((String)Resources.message, (Object)this.libref.getName());
    }

    public MustBePartOfEarToUseLibProblem(IMarker marker) {
        this(marker.getResource().getProject(), MustBePartOfEarToUseLibProblem.getLibraryModuleRefFromMarker(marker));
    }

    public static IProblem convertMarker(IMarker marker) {
        String problemType = marker.getAttribute("problem-type", null);
        if (problemType != null && problemType.equals(PROBLEM_TYPE)) {
            return new MustBePartOfEarToUseLibProblem(marker);
        }
        return null;
    }

    @Override
    public String getProblemType() {
        return PROBLEM_TYPE;
    }

    @Override
    public String getProblemId() {
        return this.id;
    }

    @Override
    public int getSeverity() {
        return 2;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return Collections.singletonMap("library-ref", this.libref);
    }

    public LibraryModuleRef getLibraryModuleRef() {
        return this.libref;
    }

    private static final class Resources
    extends NLS {
        public static String message;

        static {
            Resources.initializeMessages((String)MustBePartOfEarToUseLibProblem.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

