/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems;

import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.AbstractProblem;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.IProblem;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;

public final class ClasspathAndDescriptorRefsDoNotMatchProblem
extends AbstractProblem {
    private static final String PROBLEM_TYPE_EAR = "ClasspathAndDescriptorRefsDoNotMatchProblem_Ear";
    private static final String PROBLEM_TYPE_WEB = "ClasspathAndDescriptorRefsDoNotMatchProblem_Web";
    private static final String ATTR_LIBREF_CP = "library-ref-cp";
    private static final String ATTR_LIBREF_DESC = "library-ref-desc";
    private static final String ATTR_DESCRIPTOR_PROJECT = "descriptor-project";
    private final String id;
    private final String message;
    private final LibraryModuleRef librefFromCp;
    private final LibraryModuleRef librefFromDesc;
    private final IProject descProject;
    private final boolean isWebProject;

    public ClasspathAndDescriptorRefsDoNotMatchProblem(IProject project, LibraryModuleRef librefFromCp, LibraryModuleRef librefFromDesc, IProject descProject) {
        super(project);
        this.librefFromCp = librefFromCp;
        this.librefFromDesc = librefFromDesc;
        this.descProject = descProject;
        this.isWebProject = WtpProjectUtil.isDynamicWebProject((IProject)this.descProject);
        StringBuilder buf = new StringBuilder();
        buf.append(this.getProblemType());
        buf.append('/');
        buf.append(this.librefFromCp.getName());
        buf.append('/');
        buf.append(this.descProject.getName());
        this.id = buf.toString();
        this.message = this.isWebProject ? Resources.bind((String)Resources.messageForWebLevel, (Object)this.librefFromCp.getName()) : Resources.bind((String)Resources.messageForEarLevel, (Object)this.librefFromCp.getName(), (Object)this.descProject.getName());
    }

    public ClasspathAndDescriptorRefsDoNotMatchProblem(IMarker marker) {
        this(marker.getResource().getProject(), ClasspathAndDescriptorRefsDoNotMatchProblem.getLibraryModuleRefFromMarker(marker, ATTR_LIBREF_CP), ClasspathAndDescriptorRefsDoNotMatchProblem.getLibraryModuleRefFromMarker(marker, ATTR_LIBREF_DESC), ClasspathAndDescriptorRefsDoNotMatchProblem.getProjectFromMarker(marker, ATTR_DESCRIPTOR_PROJECT));
    }

    public static IProblem convertMarker(IMarker marker) {
        String problemType = marker.getAttribute("problem-type", null);
        if (problemType != null && (problemType.equals(PROBLEM_TYPE_EAR) || problemType.equals(PROBLEM_TYPE_WEB))) {
            return new ClasspathAndDescriptorRefsDoNotMatchProblem(marker);
        }
        return null;
    }

    @Override
    public String getProblemType() {
        return this.isWebProject ? PROBLEM_TYPE_WEB : PROBLEM_TYPE_EAR;
    }

    @Override
    public String getProblemId() {
        return this.id;
    }

    @Override
    public int getSeverity() {
        return 1;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Map<String, Object> getAttributes() {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put(ATTR_LIBREF_CP, this.librefFromCp);
        attrs.put(ATTR_LIBREF_DESC, this.librefFromDesc);
        attrs.put(ATTR_DESCRIPTOR_PROJECT, this.descProject);
        return attrs;
    }

    public LibraryModuleRef getLibraryModuleRefFromClasspath() {
        return this.librefFromCp;
    }

    public LibraryModuleRef getLibraryModuleRefFromDescriptor() {
        return this.librefFromDesc;
    }

    public IProject getDescriptorProject() {
        return this.descProject;
    }

    private static final class Resources
    extends NLS {
        public static String messageForWebLevel;
        public static String messageForEarLevel;

        static {
            Resources.initializeMessages((String)ClasspathAndDescriptorRefsDoNotMatchProblem.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

