/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems;

import java.util.Map;
import oracle.eclipse.tools.common.util.MutableReference;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.j2eelib.Version;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.IProblem;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public abstract class AbstractProblem
implements IProblem {
    public static final String MARKER_ID = "oracle.eclipse.tools.weblogic.j2eelib.validation.marker";
    public static final String PROBLEM_TYPE_ATTRIBUTE = "problem-type";
    public static final String PROBLEM_ID_ATTRIBUTE = "problem-id";
    protected static final String ATTR_LIBREF = "library-ref";
    private static final String SPECIAL_OBJECT_MARKER = "!!%%";
    private static final String NULL = "null";
    private static final String NON_NULL_STRING_PREFIX = "!";
    private static final String TYPE_LIBRARY_MODULE_REF = "!!%%" + LibraryModuleRef.class.getName();
    private static final String TYPE_PROJECT = "!!%%" + IProject.class.getName();
    protected IProject project;

    public AbstractProblem(IProject project) {
        this.project = project;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    public abstract String getProblemType();

    @Override
    public abstract String getProblemId();

    public abstract int getSeverity();

    public abstract String getMessage();

    public abstract Map<String, Object> getAttributes();

    @Override
    public void placeMarker() throws CoreException {
        IMarker m = this.project.createMarker(MARKER_ID);
        m.setAttribute("severity", this.getSeverity());
        m.setAttribute("message", (Object)this.getMessage());
        m.setAttribute(PROBLEM_TYPE_ATTRIBUTE, (Object)this.getProblemType());
        m.setAttribute(PROBLEM_ID_ATTRIBUTE, (Object)this.getProblemId());
        for (Map.Entry<String, Object> entry : this.getAttributes().entrySet()) {
            m.setAttribute(entry.getKey(), AbstractProblem.convertToMarkerAttrValue(entry.getValue()));
        }
    }

    private static Object convertToMarkerAttrValue(Object obj) {
        if (obj instanceof String || obj instanceof Integer || obj instanceof Boolean) {
            return obj;
        }
        if (obj instanceof IProject) {
            StringBuilder buf = new StringBuilder();
            buf.append(SPECIAL_OBJECT_MARKER);
            buf.append(IProject.class.getName());
            buf.append('/');
            buf.append(((IProject)obj).getName());
            return buf.toString();
        }
        if (obj instanceof LibraryModuleRef) {
            LibraryModuleRef libref = (LibraryModuleRef)obj;
            StringBuilder buf = new StringBuilder();
            buf.append(TYPE_LIBRARY_MODULE_REF);
            buf.append('/');
            buf.append(AbstractProblem.convertLibraryModuleRefToString(libref));
            return buf.toString();
        }
        throw new RuntimeException(obj.getClass().getName());
    }

    protected static String convertLibraryModuleRefToString(LibraryModuleRef libref) {
        StringBuilder buf = new StringBuilder();
        buf.append(AbstractProblem.convertNullableValueToString(libref.getName()));
        buf.append('/');
        buf.append(AbstractProblem.convertNullableValueToString(libref.getSpecificationVersion()));
        buf.append('/');
        buf.append(AbstractProblem.convertNullableValueToString(libref.getImplementationVersion()));
        buf.append('/');
        buf.append(Boolean.toString(libref.getAllowNewerVersions()));
        return buf.toString();
    }

    private static String convertNullableValueToString(Object obj) {
        if (obj == null) {
            return NULL;
        }
        return NON_NULL_STRING_PREFIX + obj.toString();
    }

    protected static Object convertFromMarkerAttrValue(Object obj) {
        if (obj instanceof Integer || obj instanceof Boolean) {
            return obj;
        }
        String str = (String)obj;
        int len = str.length();
        if (str.startsWith(TYPE_LIBRARY_MODULE_REF)) {
            MutableReference pos = new MutableReference();
            pos.set((Object)(TYPE_LIBRARY_MODULE_REF.length() + 1));
            if ((Integer)pos.get() >= len) {
                return str;
            }
            String libName = AbstractProblem.readNullableValue(str, (MutableReference<Integer>)pos);
            Version specVersion = Version.create(AbstractProblem.readNullableValue(str, (MutableReference<Integer>)pos));
            Version implVersion = Version.create(AbstractProblem.readNullableValue(str, (MutableReference<Integer>)pos));
            boolean allowNewerVersions = str.startsWith(Boolean.TRUE.toString(), (Integer)pos.get());
            return new LibraryModuleRef(libName, specVersion, implVersion, allowNewerVersions);
        }
        if (str.startsWith(TYPE_PROJECT)) {
            int startOfName = TYPE_PROJECT.length() + 1;
            String projectName = str.substring(startOfName);
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return str;
    }

    private static String readNullableValue(String str, MutableReference<Integer> pos) {
        String rawValue;
        int endOfValue = str.indexOf(47, (int)((Integer)pos.get()));
        if (endOfValue == -1) {
            endOfValue = str.length();
        }
        String finalValue = (rawValue = str.substring((Integer)pos.get(), endOfValue)).equals(NULL) ? null : rawValue.substring(NON_NULL_STRING_PREFIX.length());
        pos.set((Object)(endOfValue + 1));
        return finalValue;
    }

    protected static String getProblemTypeFromMarker(IMarker marker) {
        String problemType = marker.getAttribute(PROBLEM_TYPE_ATTRIBUTE, null);
        if (problemType == null) {
            throw new IllegalStateException();
        }
        return problemType;
    }

    protected static LibraryModuleRef getLibraryModuleRefFromMarker(IMarker marker) {
        return AbstractProblem.getLibraryModuleRefFromMarker(marker, ATTR_LIBREF);
    }

    protected static LibraryModuleRef getLibraryModuleRefFromMarker(IMarker marker, String attribute) {
        String libRefAsString = marker.getAttribute(attribute, null);
        if (libRefAsString == null) {
            throw new IllegalStateException();
        }
        return (LibraryModuleRef)AbstractProblem.convertFromMarkerAttrValue(libRefAsString);
    }

    protected static IProject getProjectFromMarker(IMarker marker, String attribute) {
        String projectAsString = marker.getAttribute(attribute, null);
        if (projectAsString == null) {
            throw new IllegalStateException();
        }
        return (IProject)AbstractProblem.convertFromMarkerAttrValue(projectAsString);
    }
}

