/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.j2eelib.internal;

import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.j2eelib.AmbiguousReferenceException;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModule;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRegistry;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModulesSvc;
import oracle.eclipse.tools.weblogic.j2eelib.UnresolvableReferenceException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public final class AddToEarPostOp
extends AbstractDataModelOperation {
    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        List<LibraryModuleRef> earRefs;
        IProject ear = this.getSourceComponent().getProject();
        try {
            earRefs = LibraryModulesSvc.getDescriptorReferences(ear);
        }
        catch (CoreException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (CoreException)e);
            return Status.OK_STATUS;
        }
        for (IVirtualComponent vc : this.getTargetComponents()) {
            List<LibraryModuleRef> refs;
            if (vc == null) continue;
            IProject proj = vc.getProject();
            try {
                refs = LibraryModulesSvc.getClasspathReferences(proj);
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (CoreException)e);
                continue;
            }
            LibraryModuleRegistry registry = LibraryModulesSvc.getRegistry();
            for (LibraryModuleRef ref : refs) {
                LibraryModule libmod;
                try {
                    libmod = registry.resolve(ref);
                }
                catch (UnresolvableReferenceException unresolvableReferenceException) {
                    continue;
                }
                catch (AmbiguousReferenceException ambiguousReferenceException) {
                    continue;
                }
                if (libmod.getType() == LibraryModule.Type.WAR || AddToEarPostOp.contains(earRefs, ref)) continue;
                try {
                    LibraryModulesSvc.addLibraryModuleRef(ear, ref, new String[0]);
                }
                catch (CoreException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (CoreException)e);
                }
            }
        }
        return Status.OK_STATUS;
    }

    public boolean canRedo() {
        return false;
    }

    public boolean canUndo() {
        return false;
    }

    private IVirtualComponent getSourceComponent() {
        return (IVirtualComponent)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT");
    }

    private List<IVirtualComponent> getTargetComponents() {
        return (List)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
    }

    private static boolean contains(List<LibraryModuleRef> refs, LibraryModuleRef ref) {
        for (LibraryModuleRef r : refs) {
            if (!r.getName().equals(ref.getName())) continue;
            return true;
        }
        return false;
    }
}

