/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.j2eelib;

public class Version
implements Comparable<Version> {
    private final String string;
    private final boolean isNumeric;
    private int[] numbers = null;
    private String qualifier;

    public Version(String version) {
        this(version, "\\.");
    }

    public Version(String version, String delimiter) {
        this.string = version;
        String[] parts = version.split(delimiter);
        int[] parsed = new int[parts.length];
        int numOfQualifier = 0;
        int i = 0;
        while (i < parts.length) {
            try {
                parsed[i] = Integer.parseInt(parts[i]);
            }
            catch (NumberFormatException numberFormatException) {
                this.qualifier = parts[i].replace('_', '-');
                ++numOfQualifier;
            }
            ++i;
        }
        this.isNumeric = parsed.length != 0 && numOfQualifier <= 1;
        if (this.isNumeric) {
            i = parsed.length - 1;
            while (i > 0 && parsed[i] == 0) {
                --i;
            }
            int length = i + 1;
            if (length == parsed.length) {
                this.numbers = parsed;
            } else {
                this.numbers = new int[length];
                System.arraycopy(parsed, 0, this.numbers, 0, length);
            }
        }
    }

    public static final Version create(String str) {
        if (str == null) {
            return null;
        }
        return new Version(str);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Version)) {
            return false;
        }
        Version v = (Version)obj;
        if (this.isNumeric && v.isNumeric) {
            if (this.numbers.length != v.numbers.length) {
                return false;
            }
            int i = 0;
            while (i < this.numbers.length) {
                if (this.numbers[i] != v.numbers[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return this.string.equals(v.string);
    }

    public int hashCode() {
        if (this.isNumeric) {
            int hashCode = 0;
            int[] nArray = this.numbers;
            int n = this.numbers.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                hashCode += i;
                ++n2;
            }
            return hashCode;
        }
        return this.string.hashCode();
    }

    @Override
    public int compareTo(Version v) {
        if (this.isNumeric && v.isNumeric) {
            int i = 0;
            while (i < this.numbers.length && i < v.numbers.length) {
                if (this.numbers[i] < v.numbers[i]) {
                    return -1;
                }
                if (this.numbers[i] > v.numbers[i]) {
                    return 1;
                }
                ++i;
            }
            if (this.numbers.length < v.numbers.length) {
                return -1;
            }
            if (this.numbers.length > v.numbers.length) {
                return 1;
            }
            if (this.qualifier != null) {
                if (v.qualifier != null) {
                    return new Version(this.qualifier, "-").compareTo(new Version(v.qualifier, "-"));
                }
                return 1;
            }
            if (v.qualifier != null) {
                return -1;
            }
            return 0;
        }
        return this.string.compareTo(v.string);
    }

    public boolean isNumeric() {
        return this.isNumeric;
    }

    public int[] getParts() {
        return this.numbers;
    }

    public String toString() {
        return this.string;
    }
}

