/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.j2eelib;

import oracle.eclipse.tools.common.util.jdt.JavaProjectUtil;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.j2eelib.Version;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public final class SharedLibraryContainer {
    public static final String CONTAINER_ID = "oracle.eclipse.tools.weblogic.lib.shared";
    public static final String LEGACY_CONTAINER_ID = "com.bea.workshop.wls.j2eelib";

    public static boolean isSharedLibraryContainer(IClasspathEntry cpe) {
        IPath path = cpe.getPath();
        if (path.segmentCount() > 0) {
            String firstSegment = path.segment(0);
            return firstSegment.equals(CONTAINER_ID) || firstSegment.equals(LEGACY_CONTAINER_ID);
        }
        return false;
    }

    public static boolean isOnClasspath(IProject project, String libraryName) throws CoreException {
        if (JavaProjectUtil.isJavaProject((IProject)project)) {
            return SharedLibraryContainer.isOnClasspath(JavaCore.create((IProject)project), libraryName);
        }
        return false;
    }

    public static boolean isOnClasspath(IJavaProject project, String libraryName) throws CoreException {
        IClasspathEntry[] cp;
        IClasspathEntry[] iClasspathEntryArray = cp = project.getRawClasspath();
        int n = cp.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path;
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (SharedLibraryContainer.isSharedLibraryContainer(cpe) && (path = cpe.getPath()).segmentCount() >= 2 && path.segment(1).equals(libraryName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void addToClasspath(IProject project, LibraryModuleRef ref) throws CoreException {
        if (JavaProjectUtil.isJavaProject((IProject)project)) {
            SharedLibraryContainer.addToClasspath(JavaCore.create((IProject)project), ref);
        }
    }

    public static void addToClasspath(IJavaProject project, LibraryModuleRef ref) throws CoreException {
        if (!SharedLibraryContainer.isOnClasspath(project, ref.getName())) {
            IClasspathEntry[] oldcp = project.getRawClasspath();
            IClasspathEntry[] newcp = new IClasspathEntry[oldcp.length + 1];
            System.arraycopy(oldcp, 0, newcp, 0, oldcp.length);
            IPath path = SharedLibraryContainer.convertLibraryRefToPath(ref);
            newcp[newcp.length - 1] = JavaCore.newContainerEntry((IPath)path);
            project.setRawClasspath(newcp, null);
        }
    }

    public static void removeFromClasspath(IProject project, String libraryName) throws CoreException {
        if (JavaProjectUtil.isJavaProject((IProject)project)) {
            SharedLibraryContainer.removeFromClasspath(JavaCore.create((IProject)project), libraryName);
        }
    }

    public static void removeFromClasspath(IJavaProject project, String libraryName) throws CoreException {
        IClasspathEntry[] oldcp = project.getRawClasspath();
        int i = 0;
        while (i < oldcp.length) {
            IPath path;
            IClasspathEntry cpe = oldcp[i];
            if (SharedLibraryContainer.isSharedLibraryContainer(cpe) && (path = cpe.getPath()).segmentCount() >= 2 && path.segment(1).equals(libraryName)) {
                IClasspathEntry[] newcp = new IClasspathEntry[oldcp.length - 1];
                System.arraycopy(oldcp, 0, newcp, 0, i);
                System.arraycopy(oldcp, i + 1, newcp, i, oldcp.length - i - 1);
                project.setRawClasspath(newcp, null);
                return;
            }
            ++i;
        }
    }

    public static IPath convertLibraryRefToPath(LibraryModuleRef ref) {
        Version implVersion;
        Path path = new Path(CONTAINER_ID);
        path = path.append(ref.getName());
        path = ref.getAllowNewerVersions() ? path.append("allow-newer") : path.append("exact");
        Version specVersion = ref.getSpecificationVersion();
        if (specVersion != null) {
            path = path.append(specVersion.toString());
        }
        if ((implVersion = ref.getImplementationVersion()) != null) {
            path = path.append(implVersion.toString());
        }
        return path;
    }

    public static LibraryModuleRef convertPathToLibraryRef(IPath path) {
        int segments = path.segmentCount();
        String name = null;
        Version specVersion = null;
        Version implVersion = null;
        boolean allowNewerVersions = true;
        if (segments < 2 || segments > 5) {
            throw new IllegalArgumentException(path.toPortableString());
        }
        if (segments >= 2) {
            name = path.segment(1);
        }
        if (segments >= 3 && path.segment(2).equals("exact")) {
            allowNewerVersions = false;
        }
        if (segments >= 4) {
            specVersion = new Version(path.segment(3));
        }
        if (segments == 5) {
            implVersion = new Version(path.segment(4));
        }
        return new LibraryModuleRef(name, specVersion, implVersion, allowNewerVersions);
    }
}

