/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.j2eelib;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.common.util.DomUtil;
import oracle.eclipse.tools.common.util.XmlParseException;
import oracle.eclipse.tools.weblogic.j2eelib.AmbiguousReferenceException;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModule;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.j2eelib.UnresolvableReferenceException;
import oracle.eclipse.tools.weblogic.j2eelib.Version;
import org.w3c.dom.Element;

public final class LibraryModuleRegistry {
    private static final String NL = System.getProperty("line.separator");
    private final File catfile;
    private final List<LibraryModule> libmodules = new ArrayList<LibraryModule>();
    private final HashSet<IListener> listeners = new HashSet();

    public LibraryModuleRegistry() {
        this(null);
    }

    public LibraryModuleRegistry(File catfile) {
        this.catfile = catfile;
        if (this.catfile != null && this.catfile.exists()) {
            try {
                for (Element e : DomUtil.elements((Element)DomUtil.root((File)catfile), (String)"library-module")) {
                    try {
                        this.libmodules.add(new LibraryModule(e));
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (XmlParseException xmlParseException) {}
        }
        new LibraryArchiveChangeMonitor(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LibraryModule[] list() {
        List<LibraryModule> list = this.libmodules;
        synchronized (list) {
            LibraryModule[] res = new LibraryModule[this.libmodules.size()];
            return this.libmodules.toArray(res);
        }
    }

    public LibraryModule resolve(LibraryModuleRef ref) throws UnresolvableReferenceException, AmbiguousReferenceException {
        List<LibraryModule> list = this.libmodules;
        synchronized (list) {
            ArrayList<LibraryModule> matches = new ArrayList<LibraryModule>();
            for (LibraryModule libmodule : this.libmodules) {
                if (!ref.match(libmodule)) continue;
                matches.add(libmodule);
            }
            if (matches.size() == 0) {
                throw new UnresolvableReferenceException(ref);
            }
            if (matches.size() == 1) {
                return (LibraryModule)matches.get(0);
            }
            LibraryModuleRegistry.removeAllExceptHighest(matches, new VersionComparator(true));
            if (matches.size() == 1) {
                return (LibraryModule)matches.get(0);
            }
            for (LibraryModule libmodule : matches) {
                Version implVersion = libmodule.getImplementationVersion();
                if (implVersion == null || implVersion.isNumeric()) continue;
                throw new AmbiguousReferenceException(matches);
            }
            LibraryModuleRegistry.removeAllExceptHighest(matches, new VersionComparator(false));
            if (matches.size() == 1) {
                return (LibraryModule)matches.get(0);
            }
            throw new AmbiguousReferenceException(matches);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isConflicting(LibraryModule libmodule, LibraryModule ignore) {
        List<LibraryModule> list = this.libmodules;
        synchronized (list) {
            LibraryModule m;
            Iterator<LibraryModule> iterator = this.libmodules.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((m = iterator.next()) == ignore || !m.getName().equals(libmodule.getName()) || !LibraryModuleRegistry.equals(m.getSpecificationVersion(), libmodule.getSpecificationVersion()) || !LibraryModuleRegistry.equals(m.getImplementationVersion(), libmodule.getImplementationVersion()));
            return true;
        }
    }

    public void add(LibraryModule libmodule) {
        this.add(libmodule, ConflictResolutionStrategyForAdd.REPLACE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(LibraryModule libmodule, ConflictResolutionStrategyForAdd conflictResolutionStrategy) {
        List<LibraryModule> list = this.libmodules;
        synchronized (list) {
            for (LibraryModule m : this.libmodules) {
                if (m.getLocation().equals(libmodule.getLocation())) {
                    return;
                }
                if (!m.getName().equals(libmodule.getName()) || !LibraryModuleRegistry.equals(m.getSpecificationVersion(), libmodule.getSpecificationVersion()) || !LibraryModuleRegistry.equals(m.getImplementationVersion(), libmodule.getImplementationVersion())) continue;
                if (conflictResolutionStrategy == ConflictResolutionStrategyForAdd.IGNORE) {
                    return;
                }
                if (conflictResolutionStrategy == ConflictResolutionStrategyForAdd.REPLACE) {
                    this.libmodules.remove(m);
                    break;
                }
                if (conflictResolutionStrategy == ConflictResolutionStrategyForAdd.FAIL) {
                    String msg = "Conflicting: \"" + m.getLocation() + "\" and \"" + libmodule.getLocation() + "\".";
                    throw new IllegalArgumentException(msg);
                }
                throw new IllegalArgumentException();
            }
            this.libmodules.add(libmodule);
            this.save();
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swap(LibraryModule oldLibModule, LibraryModule newLibModule) {
        List<LibraryModule> list = this.libmodules;
        synchronized (list) {
            if (this.isConflicting(newLibModule, oldLibModule)) {
                throw new IllegalArgumentException("conflicting");
            }
            this.libmodules.remove(oldLibModule);
            this.libmodules.add(newLibModule);
            this.save();
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(LibraryModule libmodule) {
        List<LibraryModule> list = this.libmodules;
        synchronized (list) {
            this.libmodules.remove(libmodule);
            this.save();
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IListener listener) {
        HashSet<IListener> hashSet = this.listeners;
        synchronized (hashSet) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IListener listener) {
        HashSet<IListener> hashSet = this.listeners;
        synchronized (hashSet) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        ArrayList<IListener> copy;
        HashSet<IListener> hashSet = this.listeners;
        synchronized (hashSet) {
            copy = new ArrayList<IListener>(this.listeners);
        }
        for (IListener listener : copy) {
            listener.registryChanged();
        }
    }

    private void save() {
        block17: {
            if (this.catfile != null) {
                File dir = this.catfile.getParentFile();
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                OutputStreamWriter w = null;
                try {
                    try {
                        w = new OutputStreamWriter((OutputStream)new FileOutputStream(this.catfile), StandardCharsets.UTF_8);
                        w.write("<library-modules>");
                        w.write(NL);
                        for (LibraryModule libmodule : this.libmodules) {
                            libmodule.write(w);
                        }
                        w.write("</library-modules>");
                        w.write(NL);
                        w.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        if (w != null) {
                            try {
                                w.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (w != null) {
                        try {
                            w.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (w != null) {
                    try {
                        w.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static void removeAllExceptHighest(List<LibraryModule> list, Comparator<LibraryModule> comparator) {
        Collections.sort(list, comparator);
        LibraryModule highest = null;
        int lastHighestPosition = 0;
        for (LibraryModule obj : list) {
            if (highest == null) {
                highest = obj;
                continue;
            }
            if (comparator.compare(highest, obj) != 0) break;
            ++lastHighestPosition;
        }
        int i = list.size() - 1;
        while (i > lastHighestPosition) {
            list.remove(i);
            --i;
        }
    }

    public boolean isLibraryExisting(LibraryModuleRef ref) {
        LibraryModule[] libModules;
        LibraryModule[] libraryModuleArray = libModules = this.list();
        int n = libModules.length;
        int n2 = 0;
        while (n2 < n) {
            LibraryModule m = libraryModuleArray[n2];
            if (m.getName().equals(ref.getName()) && LibraryModuleRegistry.equals(m.getSpecificationVersion(), ref.getSpecificationVersion()) && LibraryModuleRegistry.equals(m.getImplementationVersion(), ref.getImplementationVersion())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean equals(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static enum ConflictResolutionStrategyForAdd {
        IGNORE,
        REPLACE,
        FAIL;

    }

    public static interface IListener {
        public void registryChanged();
    }

    private static final class LibraryArchiveChangeMonitor
    extends Thread {
        private final WeakReference<LibraryModuleRegistry> refRegistry;

        public LibraryArchiveChangeMonitor(LibraryModuleRegistry registry) {
            this.refRegistry = new WeakReference<LibraryModuleRegistry>(registry);
        }

        @Override
        public void run() {
            block2: while (true) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
                LibraryModuleRegistry registry = (LibraryModuleRegistry)this.refRegistry.get();
                if (registry == null) {
                    return;
                }
                LibraryModule[] libraryModuleArray = registry.list();
                int n = libraryModuleArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block2;
                    LibraryModule lib = libraryModuleArray[n2];
                    lib.checkForChanges();
                    ++n2;
                }
                break;
            }
        }
    }

    private static final class VersionComparator
    implements Comparator<LibraryModule> {
        private final boolean isSpec;

        public VersionComparator(boolean isSpec) {
            this.isSpec = isSpec;
        }

        @Override
        public int compare(LibraryModule x, LibraryModule y) {
            Version v2;
            Version v1;
            if (this.isSpec) {
                v1 = x.getSpecificationVersion();
                v2 = y.getSpecificationVersion();
            } else {
                v1 = x.getImplementationVersion();
                v2 = y.getImplementationVersion();
            }
            if (v1 == null && v2 == null) {
                return 0;
            }
            if (v1 == null) {
                return 1;
            }
            if (v2 == null) {
                return -1;
            }
            return v2.compareTo(v1);
        }
    }
}

