/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.j2eelib;

import oracle.eclipse.tools.weblogic.j2eelib.LibraryModule;
import oracle.eclipse.tools.weblogic.j2eelib.Version;

public final class LibraryModuleRef {
    private final String name;
    private final Version specVersion;
    private final Version implVersion;
    private final boolean allowNewerVersions;

    public LibraryModuleRef(String name, Version specVersion, Version implVersion, boolean allowNewerVersions) {
        this.name = name;
        this.specVersion = specVersion;
        this.implVersion = implVersion;
        this.allowNewerVersions = allowNewerVersions;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LibraryModuleRef)) {
            return false;
        }
        LibraryModuleRef ref = (LibraryModuleRef)obj;
        return LibraryModuleRef.equals(this.name, ref.name) && LibraryModuleRef.equals(this.specVersion, ref.specVersion) && LibraryModuleRef.equals(this.implVersion, ref.implVersion) && this.allowNewerVersions == ref.allowNewerVersions;
    }

    public int hashCode() {
        int c = this.allowNewerVersions ? 3 : 5;
        c += this.name != null ? this.name.hashCode() : 7;
        c += this.specVersion != null ? this.specVersion.hashCode() : 11;
        return c += this.implVersion != null ? this.implVersion.hashCode() : 13;
    }

    public String getName() {
        return this.name;
    }

    public Version getSpecificationVersion() {
        return this.specVersion;
    }

    public Version getImplementationVersion() {
        return this.implVersion;
    }

    public boolean getAllowNewerVersions() {
        return this.allowNewerVersions;
    }

    public boolean match(LibraryModule libmodule) {
        String libName = libmodule.getName();
        return this.name.equals(libName) && LibraryModuleRef.match(this.specVersion, libmodule.getSpecificationVersion(), this.allowNewerVersions) && LibraryModuleRef.match(this.implVersion, libmodule.getImplementationVersion(), this.allowNewerVersions);
    }

    public static boolean matchName(LibraryModuleRef ref, String libName) {
        int n = libName.indexOf("#");
        if (n > 0) {
            String simpleName = libName.substring(0, n);
            return ref.getName().equals(simpleName);
        }
        return ref.getName().equals(libName);
    }

    public static boolean match(Version v1, Version v2, boolean allowNewerVersions) {
        if (v1 != null) {
            if (v2 == null) {
                return false;
            }
            if (allowNewerVersions && v1.isNumeric() && v2.isNumeric() ? v2.compareTo(v1) < 0 : !v1.equals(v2)) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(LibraryModuleRef.toStringWithNullSupport(this.name));
        buf.append('|');
        buf.append(LibraryModuleRef.toStringWithNullSupport(this.specVersion));
        buf.append('|');
        buf.append(LibraryModuleRef.toStringWithNullSupport(this.implVersion));
        buf.append('|');
        buf.append(this.allowNewerVersions);
        return buf.toString();
    }

    private static boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    private static String toStringWithNullSupport(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.toString();
    }
}

