/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.j2eelib;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModule;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleContainer;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModulesSvc;
import oracle.eclipse.tools.weblogic.j2eelib.SharedLibraryContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public final class LibraryModuleContainerInitializer
extends ClasspathContainerInitializer {
    public void initialize(IPath path, IJavaProject jproj) throws CoreException {
        IJavaProject[] projects = new IJavaProject[]{jproj};
        LibraryModuleContainer container = new LibraryModuleContainer(jproj, path);
        IClasspathContainer[] containers = new IClasspathContainer[]{container};
        JavaCore.setClasspathContainer((IPath)path, (IJavaProject[])projects, (IClasspathContainer[])containers, null);
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer sg) throws CoreException {
        Path root;
        LibraryModuleRef libmodref = SharedLibraryContainer.convertPathToLibraryRef(containerPath);
        LibraryModule libmod = LibraryModulesSvc.resolve(libmodref);
        try {
            root = new Path(libmod.explode().getAbsolutePath());
        }
        catch (IOException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (Throwable)e);
            return;
        }
        HashMap<String, File> sourceLocations = new HashMap<String, File>();
        HashMap<String, URL> javadocLocations = new HashMap<String, URL>();
        boolean changed = true;
        IClasspathEntry[] iClasspathEntryArray = sg.getClasspathEntries();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            IPath p = cpe.getPath().removeFirstSegments(root.segmentCount());
            p = p.setDevice(null);
            String pathstr = p.toPortableString();
            File src = LibraryModuleContainerInitializer.getSourceLocation(cpe);
            URL javadoc = LibraryModuleContainerInitializer.getJavadocLocation(cpe);
            if (!LibraryModuleContainerInitializer.equals(src, libmod.getSourceLocation(pathstr)) || !LibraryModuleContainerInitializer.equals(javadoc, libmod.getJavadocLocation(pathstr))) {
                changed = true;
            }
            if (src != null) {
                sourceLocations.put(pathstr, src);
            }
            if (javadoc != null) {
                javadocLocations.put(pathstr, javadoc);
            }
            ++n2;
        }
        if (changed) {
            LibraryModule newLibraryModule;
            try {
                newLibraryModule = new LibraryModule(libmod.getLocation(), libmod.getName(), libmod.getSpecificationVersion(), libmod.getImplementationVersion(), sourceLocations, javadocLocations, LibraryModulesSvc.getTempDir());
            }
            catch (IOException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (Throwable)e);
                return;
            }
            LibraryModulesSvc.getRegistry().swap(libmod, newLibraryModule);
        }
    }

    public Object getComparisonID(IPath containerPath, IJavaProject project) {
        if (containerPath == null) {
            return null;
        }
        return containerPath.toPortableString();
    }

    private static boolean equals(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    private static final File getSourceLocation(IClasspathEntry cpe) {
        IPath path = cpe.getSourceAttachmentPath();
        return path == null ? null : path.toFile();
    }

    private static final URL getJavadocLocation(IClasspathEntry cpe) {
        IClasspathAttribute[] iClasspathAttributeArray = cpe.getExtraAttributes();
        int n = iClasspathAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attr = iClasspathAttributeArray[n2];
            if (attr.getName().equals("javadoc_location")) {
                try {
                    return new URL(attr.getValue());
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            ++n2;
        }
        return null;
    }
}

