/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.j2eelib;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import oracle.eclipse.tools.common.util.fileio.ZipUtil;
import oracle.eclipse.tools.common.util.jdt.JavaProjectUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.j2eelib.AmbiguousReferenceException;
import oracle.eclipse.tools.weblogic.j2eelib.ClasspathEntry;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModule;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModulesSvc;
import oracle.eclipse.tools.weblogic.j2eelib.SharedLibraryContainer;
import oracle.eclipse.tools.weblogic.j2eelib.UnresolvableReferenceException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;

public final class LibraryModuleContainer
implements IClasspathContainer {
    private static final IClasspathEntry[] EMPTY_CP = new IClasspathEntry[0];
    private final IJavaProject jproj;
    private final IPath path;
    private final LibraryModuleRef ref;
    private LibraryModule libmodule;
    private IClasspathEntry[] cpentries;
    private Exception error = null;
    private LibraryModule.Listener listener;

    public LibraryModuleContainer(IJavaProject jproj, IPath path) {
        this.jproj = jproj;
        this.path = path;
        this.ref = SharedLibraryContainer.convertPathToLibraryRef(path);
        try {
            this.libmodule = LibraryModulesSvc.getRegistry().resolve(this.ref);
            if (!this.libmodule.exists()) {
                this.error = new FileNotFoundException();
            }
        }
        catch (UnresolvableReferenceException e) {
            this.error = e;
        }
        catch (AmbiguousReferenceException e) {
            this.error = e;
        }
        this.cpentries = EMPTY_CP;
        if (this.libmodule != null) {
            if (this.libmodule.exists()) {
                Set<ClasspathEntry> cp = null;
                try {
                    cp = this.libmodule.getClasspathEntries(jproj.getProject());
                }
                catch (IOException e) {
                    this.error = e;
                }
                if (cp != null) {
                    this.cpentries = new IClasspathEntry[cp.size()];
                    int i = 0;
                    for (ClasspathEntry cpe : cp) {
                        IClasspathEntry entry;
                        File f = cpe.getLocation();
                        if (f.isDirectory()) {
                            File jar = new File(f.getParentFile(), "classes.jar");
                            if (!jar.exists()) {
                                try {
                                    ZipUtil.zip((File)f, (File)jar);
                                }
                                catch (IOException e) {
                                    LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (Throwable)e);
                                    continue;
                                }
                            }
                            f = jar;
                        }
                        Path p = new Path(f.getPath());
                        File src = cpe.getSourceLocaton();
                        Path srcpath = src == null ? null : new Path(src.getAbsolutePath());
                        this.cpentries[i] = entry = JavaProjectUtil.newLibraryEntry((IPath)p, (IPath)srcpath, (URL)cpe.getJavadocLocation());
                        ++i;
                    }
                }
            }
            this.listener = new LibraryModule.Listener(){

                @Override
                public void libraryArchiveChanged() {
                    LibraryModuleContainer.this.refresh(true);
                }
            };
            this.libmodule.addListener(this.listener);
        }
    }

    public IClasspathEntry[] getClasspathEntries() {
        if (this.isOutOfDate()) {
            Thread refreshThread = new Thread(){

                @Override
                public void run() {
                    LibraryModuleContainer.this.refresh(true);
                }
            };
            refreshThread.start();
        }
        return this.cpentries;
    }

    public String getDescription() {
        return NLS.bind((String)Resources.label, (Object)this.ref.getName());
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.path;
    }

    public static void handleRegistryChangedEvent() {
        try {
            IProject[] projects;
            IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (JavaProjectUtil.isJavaProject((IProject)project)) {
                    IJavaProject jpj = JavaCore.create((IProject)project);
                    IClasspathEntry[] iClasspathEntryArray = jpj.getRawClasspath();
                    int n3 = iClasspathEntryArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IClasspathEntry cpe = iClasspathEntryArray[n4];
                        if (SharedLibraryContainer.isSharedLibraryContainer(cpe)) {
                            IClasspathContainer container = JavaCore.getClasspathContainer((IPath)cpe.getPath(), (IJavaProject)jpj);
                            ((LibraryModuleContainer)container).refresh();
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (CoreException)e);
        }
    }

    private void refresh() {
        this.refresh(false);
    }

    private void refresh(boolean force) {
        boolean needsRefresh;
        block7: {
            needsRefresh = false;
            try {
                LibraryModule newlibmod = LibraryModulesSvc.getRegistry().resolve(this.ref);
                if (newlibmod != this.libmodule) {
                    needsRefresh = true;
                }
            }
            catch (Exception e) {
                if (e == this.error) break block7;
                needsRefresh = true;
            }
        }
        if (needsRefresh || force) {
            if (this.libmodule != null) {
                this.libmodule.removeListener(this.listener);
            }
            IJavaProject[] projects = new IJavaProject[]{this.jproj};
            LibraryModuleContainer container = new LibraryModuleContainer(this.jproj, this.getPath());
            IClasspathContainer[] containers = new IClasspathContainer[]{container};
            try {
                JavaCore.setClasspathContainer((IPath)this.getPath(), (IJavaProject[])projects, (IClasspathContainer[])containers, null);
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (CoreException)e);
            }
        }
    }

    private boolean isOutOfDate() {
        if (this.libmodule == null || !this.libmodule.exists()) {
            return false;
        }
        Set<Object> cp = Collections.emptySet();
        try {
            cp = this.libmodule.getClasspathEntries(this.jproj.getProject());
        }
        catch (IOException iOException) {}
        if (this.cpentries.length != cp.size()) {
            return true;
        }
        int i = 0;
        for (ClasspathEntry classpathEntry : cp) {
            File y;
            File x = classpathEntry.getLocation();
            if (x.isDirectory()) {
                x = new File(x.getParentFile(), "classes.jar");
            }
            if (!x.equals(y = this.cpentries[i].getPath().toFile())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final class Resources
    extends NLS {
        public static String label;

        static {
            Resources.initializeMessages((String)LibraryModuleContainer.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

