/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.internal;

import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.weblogic.WlsRuntimeClassLoader;
import oracle.eclipse.tools.weblogic.WlsRuntimeComponentType;
import oracle.eclipse.tools.weblogic.internal.WlsRuntimeClassLoaderBuilder;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntime;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.Runtime;

final class WlsRuntimeClasspathFactory {
    private static final String EXTENSION_ID = "wlsRuntimeClasspath";
    private final Map<IRuntimeComponentVersion, WlsRuntimeClassLoaderBuilder> _builders = new HashMap<IRuntimeComponentVersion, WlsRuntimeClassLoaderBuilder>();

    WlsRuntimeClasspathFactory() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("oracle.eclipse.tools.weblogic", EXTENSION_ID);
        if (point == null) {
            throw new IllegalStateException("Extension point (wlsRuntimeClasspath) not found!");
        }
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            String contributor = extension.getContributor().getName();
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    if ("runtime".equals(element.getName())) {
                        IRuntimeComponentVersion version = WlsRuntimeComponentType.INSTANCE.getVersion(PluginUtil.findRequiredAttribute((IConfigurationElement)element, (String)"version"));
                        WlsRuntimeClassLoaderBuilder builder = this._builders.get(version);
                        if (builder == null) {
                            builder = new WlsRuntimeClassLoaderBuilder(contributor);
                            builder.setParentBundleId("org.eclipse.jdt.apt.core");
                            builder.setRuntimeComponent(version);
                            this._builders.put(version, builder);
                        }
                        IConfigurationElement[] iConfigurationElementArray2 = element.getChildren();
                        int n5 = iConfigurationElementArray2.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IConfigurationElement entryElement = iConfigurationElementArray2[n6];
                            if ("entry".equals(entryElement.getName())) {
                                builder.addPathEntry(contributor, PluginUtil.findRequiredAttribute((IConfigurationElement)entryElement, (String)"path"));
                            } else {
                                PluginUtil.reportInvalildElement((IExtension)extension, (IConfigurationElement)element);
                            }
                            ++n6;
                        }
                    } else {
                        PluginUtil.reportInvalildElement((IExtension)extension, (IConfigurationElement)element);
                    }
                }
                catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
                ++n4;
            }
            ++n2;
        }
    }

    WlsRuntimeClassLoader getClassLoaderForRuntime(IRuntimeComponent component) {
        assert (component != null);
        assert ("com.bea.weblogic".equals(component.getRuntimeComponentType().getId()));
        WlsRuntimeClassLoaderBuilder builder = this._builders.get(component.getRuntimeComponentVersion());
        return builder != null ? builder.getClassLoader(component) : null;
    }

    public void reset(IRuntime runtime) {
        assert (runtime != null);
        IWeblogicServerRuntime wsr = (IWeblogicServerRuntime)((Runtime)runtime).loadAdapter(IWeblogicServerRuntime.class, null);
        for (WlsRuntimeClassLoaderBuilder builder : this._builders.values()) {
            builder.resetLocation(runtime.getLocation(), wsr.getPatchProfileJarPath());
        }
    }
}

