/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.internal;

import javax.rmi.PortableRemoteObject;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.WlsDescriptorCatalog;
import oracle.eclipse.tools.weblogic.WlsRuntimeSpy;
import oracle.eclipse.tools.weblogic.internal.ResourceChangeListener;
import oracle.eclipse.tools.weblogic.internal.WlsRuntimeClasspathFactory;
import oracle.eclipse.tools.weblogic.j2eelib.internal.SharedLibraryRegistryListener;
import org.eclipse.core.internal.registry.osgi.OSGIUtils;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.internal.IStartup;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public final class WlsCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "oracle.eclipse.tools.weblogic";
    private static final String TEMP_DIR = ".metadata/.plugins/oracle.eclipse.tools.weblogic/temp";
    private static final IPath TEMP_DIR_ABSOLUTE = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(".metadata/.plugins/oracle.eclipse.tools.weblogic/temp");
    private WlsRuntimeClasspathFactory classpathFactory;
    private static WlsCorePlugin instance = null;

    public WlsCorePlugin() {
        instance = this;
        this.classpathFactory = null;
    }

    public static final Bundle getPluginBundle() {
        return Platform.getBundle((String)PLUGIN_ID);
    }

    public static WlsCorePlugin getInstance() {
        return instance;
    }

    public synchronized WlsRuntimeClasspathFactory getClassLoaderFactory() {
        if (this.classpathFactory == null) {
            this.classpathFactory = new WlsRuntimeClasspathFactory();
        }
        return this.classpathFactory;
    }

    public static IStatus createErrorStatus(String msg) {
        return WlsCorePlugin.createErrorStatus(msg, null);
    }

    public static IStatus createErrorStatus(Exception e) {
        return WlsCorePlugin.createErrorStatus(e.getMessage(), e);
    }

    public static IStatus createErrorStatus(String msg, Exception e) {
        String message = msg;
        if (message == null) {
            message = "";
        }
        return new Status(4, PLUGIN_ID, 0, message, (Throwable)e);
    }

    public static void logException(Exception e) {
        LoggingService.logException((String)PLUGIN_ID, (Throwable)e);
    }

    public static void logError(String msg) {
        LoggingService.logError((String)PLUGIN_ID, (String)msg);
    }

    public static IPath getTempDir() {
        return TEMP_DIR_ABSOLUTE;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public static final class StartupHandler
    implements IStartup {
        public void startup() {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    WlsRuntimeSpy.initialize();
                    SharedLibraryRegistryListener.register();
                    ResourceChangeListener.register();
                    WlsDescriptorCatalog.getInstance();
                    StartupHandler.this.resetPortableRemoteObjectClass();
                }
            };
            thread.start();
        }

        private void resetPortableRemoteObjectClass() {
            boolean isJRMCPresent;
            Bundle jrmcBundle = OSGIUtils.getDefault().getBundle("com.jrockit.mc.core");
            boolean bl = isJRMCPresent = jrmcBundle != null;
            if (isJRMCPresent) {
                String rmiPortableRemoteObjectClass = System.getProperty("javax.rmi.CORBA.PortableRemoteObjectClass", null);
                if (rmiPortableRemoteObjectClass != null) {
                    System.clearProperty("javax.rmi.CORBA.PortableRemoteObjectClass");
                }
                PortableRemoteObject.narrow(null, null);
                if (rmiPortableRemoteObjectClass != null) {
                    System.setProperty("javax.rmi.CORBA.PortableRemoteObjectClass", rmiPortableRemoteObjectClass);
                }
            }
        }
    }
}

