/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.internal;

import oracle.eclipse.tools.common.util.ObjectUtil;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicWebModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.WebLogicDescriptorFactory;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;

public final class ResourceChangeListener
implements IResourceChangeListener {
    private static final IPath PATH_COMPONENT_FILE = new Path(".settings/org.eclipse.wst.common.component");

    public static void register() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ws.addResourceChangeListener((IResourceChangeListener)new ResourceChangeListener(), 1);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta subdelta = iResourceDeltaArray[n2];
            IProject project = (IProject)subdelta.getResource();
            if (WtpProjectUtil.isDynamicWebProject((IProject)project)) {
                IVirtualComponent vc;
                IVirtualFile vf;
                IFile file;
                if (subdelta.findMember(PATH_COMPONENT_FILE) != null) {
                    ResourceChangeListener.scheduleContextRootUpdateInDescriptor(project);
                }
                if (subdelta.findMember((file = (vf = (vc = ComponentCore.createComponent((IProject)project)).getRootFolder().getFile("WEB-INF/weblogic.xml")).getUnderlyingFile()).getProjectRelativePath()) != null) {
                    ResourceChangeListener.scheduleContextRootUpdateInMetadata(project);
                }
            }
            ++n2;
        }
    }

    private static void scheduleContextRootUpdateInMetadata(final IProject project) {
        Job job = new Job(Resources.contextRootUpdateJobName){

            protected IStatus run(IProgressMonitor monitor) {
                IWebLogicWebModuleDescriptor descriptor = WebLogicDescriptorFactory.getWebDescriptor(project);
                try {
                    try {
                        String contextRootInMetadata;
                        String contextRootInDescriptor;
                        if (descriptor != null && ((XmlResource)descriptor.adapt(XmlResource.class)).getXmlElement(false) != null && !ObjectUtil.equal((Object)(contextRootInDescriptor = descriptor.getContextRoot().text(true)), (Object)(contextRootInMetadata = ComponentUtilities.getServerContextRoot((IProject)project)))) {
                            ComponentUtilities.setServerContextRoot((IProject)project, (String)contextRootInDescriptor);
                        }
                    }
                    catch (Exception e) {
                        WlsCorePlugin.logException(e);
                        descriptor.dispose();
                    }
                }
                finally {
                    descriptor.dispose();
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
    }

    private static void scheduleContextRootUpdateInDescriptor(final IProject project) {
        Job job = new Job(Resources.contextRootUpdateJobName){

            protected IStatus run(IProgressMonitor monitor) {
                IWebLogicWebModuleDescriptor descriptor = WebLogicDescriptorFactory.getWebDescriptor(project);
                try {
                    try {
                        String contextRootInMetadata;
                        String contextRootInDescriptor;
                        if (descriptor != null && ((XmlResource)descriptor.adapt(XmlResource.class)).getXmlElement(false) != null && !ObjectUtil.equal((Object)(contextRootInDescriptor = descriptor.getContextRoot().text(true)), (Object)(contextRootInMetadata = ComponentUtilities.getServerContextRoot((IProject)project)))) {
                            descriptor.setContextRoot(contextRootInMetadata);
                            descriptor.resource().save();
                        }
                    }
                    catch (Exception e) {
                        WlsCorePlugin.logException(e);
                        descriptor.dispose();
                    }
                }
                finally {
                    descriptor.dispose();
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.setRule((ISchedulingRule)project);
        job.schedule();
    }

    private static final class Resources
    extends NLS {
        public static String contextRootUpdateJobName;

        static {
            Resources.initializeMessages((String)ResourceChangeListener.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

