/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.internal;

import java.util.ArrayList;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.wtp.core.ServerUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerUtil;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.server.IWeblogicServer;
import oracle.eclipse.tools.weblogic.syslib.SystemLibrariesContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IPrimaryRuntimeChangedEvent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;

public final class FacetedProjectListener
implements IFacetedProjectListener {
    public void handleEvent(IFacetedProjectEvent event) {
        IPrimaryRuntimeChangedEvent evt;
        IRuntime runtime;
        final IProject project = event.getProject().getProject();
        if (event.getType() == IFacetedProjectEvent.Type.PRIMARY_RUNTIME_CHANGED && (runtime = (evt = (IPrimaryRuntimeChangedEvent)event).getNewPrimaryRuntime()) != null && WlsRuntimeUtil.isWlsRuntime(runtime)) {
            try {
                SystemLibrariesContainer.refreshContainer(project);
            }
            catch (CoreException e) {
                WlsCorePlugin.logException((Exception)((Object)e));
            }
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                FacetedProjectListener.processChangedProject(project);
            }
        };
        t.start();
    }

    private static void processChangedProject(IProject project) {
        for (IServer server : WebLogicServerUtil.getWebLogicServers()) {
            if (!ServerUtil.isAssociatedWithServer((IServer)server, (IProject)project)) continue;
            IWeblogicServer wlServer = (IWeblogicServer)server.getAdapter(IWeblogicServer.class);
            ArrayList<IModule> modulesNoLongerSupported = null;
            IModule[] iModuleArray = server.getModules();
            int n = iModuleArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModule module = iModuleArray[n2];
                if (!wlServer.canSupportModule(module).isOK()) {
                    if (modulesNoLongerSupported == null) {
                        modulesNoLongerSupported = new ArrayList<IModule>();
                    }
                    modulesNoLongerSupported.add(module);
                } else if (server.getServerState() == 2 && module.getModuleType().getId().equals("jst.ear")) {
                    final IModule earModule = module;
                    final IServer server2 = server;
                    final IProject project2 = project;
                    if (project.isOpen()) {
                        Job job = new Job("Updating module publishing state"){

                            protected IStatus run(IProgressMonitor monitor) {
                                IModule[] childModules = server2.getChildModules(new IModule[]{earModule}, monitor);
                                int i = 0;
                                while (i < childModules.length) {
                                    if (childModules[i].getProject() == project2) {
                                        ((Server)server2).setModulePublishState(new IModule[]{earModule}, 3);
                                    }
                                    ++i;
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule();
                    }
                }
                ++n2;
            }
            if (modulesNoLongerSupported == null) continue;
            try {
                ServerUtil.removeModulesFromServer((IServer)server, modulesNoLongerSupported);
                if (server.getServerState() != 2) continue;
                server.publish(3, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (CoreException)e);
            }
        }
    }
}

