/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.facets.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public final class AptFacetInstallDelegate
implements IDelegate {
    private static final String SRC_GEN_DIR = ".apt_src";
    private static final IProjectFacet UTILITY_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.utility");
    private static final IProjectFacet EJB_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");

    public void execute(IProject project, IProjectFacetVersion facetVersion, Object cfg, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            IJavaProject jproj = JavaCore.create((IProject)project);
            AptConfig.setGenSrcDir((IJavaProject)jproj, (String)SRC_GEN_DIR);
            AptConfig.setEnabled((IJavaProject)jproj, (boolean)true);
            IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
            IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
            IVirtualFolder target = null;
            if (fproj.hasProjectFacet(WebFacetUtils.WEB_24.getProjectFacet())) {
                target = vc.getRootFolder().getFolder("/WEB-INF/classes");
            } else if (fproj.hasProjectFacet(UTILITY_FACET) || fproj.hasProjectFacet(EJB_FACET)) {
                target = vc.getRootFolder();
            }
            if (target != null) {
                target.createLink((IPath)new Path(SRC_GEN_DIR), 0, null);
            }
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }
}

