/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ejb.upgrade;

import java.util.Set;
import oracle.eclipse.tools.common.builder.BuilderUtils;
import oracle.eclipse.tools.common.upgrade.AbstractProjectUpgradeParticipant;
import oracle.eclipse.tools.common.upgrade.IProjectUpgradeParticipant;
import oracle.eclipse.tools.common.util.ProjectUtil;
import oracle.eclipse.tools.common.util.jdt.JavaProjectUtil;
import oracle.eclipse.tools.common.util.wtp.ValidatorUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public final class EJBProjectUpgradeParticipant
extends AbstractProjectUpgradeParticipant {
    private static final String OLD_NATURE = "com.bea.wlw.ejb.core.ejbProjectNature";
    private static final String NEW_NATURE = "oracle.eclipse.tools.weblogic.ejbProjectNature";
    private static final String OLD_BUILDER = "com.bea.wlw.ejb.core.EJBGenBuilder";
    private static final String NEW_BUILDER = "oracle.eclipse.tools.weblogic.EJBGenBuilder";
    private static final String OLD_APT_PLUGIN_ID = "com.bea.wlw.ejb.apt";

    public boolean check(IProject project) throws CoreException {
        return project.hasNature(OLD_NATURE) || project.hasNature(NEW_NATURE);
    }

    protected void prepare(IProject project, Set<IProjectUpgradeParticipant.Action> actions) {
        IFile f = project.getFile(".project");
        actions.add(new IProjectUpgradeParticipant.Action(IProjectUpgradeParticipant.Action.Type.EDIT, f));
        f = project.getFile(".factorypath");
        actions.add(new IProjectUpgradeParticipant.Action(IProjectUpgradeParticipant.Action.Type.EDIT, f));
    }

    public void execute(IProject project, IProgressMonitor monitor) throws CoreException {
        if (project.hasNature(OLD_NATURE)) {
            ProjectUtil.removeNature((IProject)project, (String)OLD_NATURE);
            BuilderUtils.replaceBuilder((IProject)project, (String)OLD_BUILDER, (String)NEW_BUILDER);
            JavaProjectUtil.replaceAptFactoryPathPlugin((IProject)project, (String)OLD_APT_PLUGIN_ID, (String)"oracle.eclipse.tools.weblogic");
            ValidatorUtil.disableValidation((IProject)project, (String[])new String[]{"org.eclipse.jst.j2ee.internal.ejb.workbench.validation.UIEjbValidator"});
        } else if (project.hasNature(NEW_NATURE)) {
            ProjectUtil.removeNature((IProject)project, (String)NEW_NATURE);
        }
    }
}

