/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ejb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.eclipse.tools.weblogic.ejb.EJBProjectMessages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;

public class EJBCoreUtil {
    public static final String EJB_CONTENT_TYPE_ID_PREFIX = "oracle.eclipse.tools.weblogic";
    public static final String EJBGEN_ENTITY_CONTENT_TYPE = "oracle.eclipse.tools.weblogic.entity";
    public static final String EJBGEN_SESSION_CONTENT_TYPE = "oracle.eclipse.tools.weblogic.session";
    public static final String EJBGEN_MESSAGE_DRIVEN_CONTENT_TYPE = "oracle.eclipse.tools.weblogic.message";
    public static final String EJB3_STATELESS_SESSION_CONTENT_TYPE = "oracle.eclipse.tools.weblogic.ejb3stateless";
    public static final String EJB3_STATEFUL_SESSION_CONTENT_TYPE = "oracle.eclipse.tools.weblogic.ejb3stateful";
    public static final String EJB3_MESSAGE_DRIVEN_CONTENT_TYPE = "oracle.eclipse.tools.weblogic.ejb3message";
    public static final String EJBGEN_PROBLEM = "oracle.eclipse.tools.weblogic.ejbgenProblem";

    public static IFolder getAPTOutputFolder(IProject project) {
        return EJBCoreUtil.getAPTOutputFolder(JavaCore.create((IProject)project));
    }

    public static IFolder getAPTOutputFolder(IJavaProject jp) {
        String folder = AptConfig.getGenSrcDir((IJavaProject)jp);
        return jp.getProject().getFolder(folder);
    }

    public static IPath[] getEJBSrcPath(IJavaProject jproj) throws CoreException {
        IPath[][] paths = EJBCoreUtil.getEJBSrcPaths(jproj);
        if (paths.length == 0 || paths[0].length != 2) {
            return new IPath[0];
        }
        IPath[] firstPath = new IPath[]{paths[0][0], paths[0][1]};
        return firstPath;
    }

    public static IPath[][] getEJBSrcPaths(IJavaProject jproj) throws CoreException {
        IPath aptGenDir = EJBCoreUtil.getAPTOutputFolder(jproj).getFullPath().removeFirstSegments(1);
        IClasspathEntry[] cp = jproj.getRawClasspath();
        ArrayList<IPath[]> paths = new ArrayList<IPath[]>();
        int i = 0;
        while (i < cp.length) {
            IClasspathEntry cpe = cp[i];
            IPath[] p = new IPath[2];
            IPath path = cpe.getPath().removeFirstSegments(1);
            if (cpe.getEntryKind() == 3 && !path.equals((Object)aptGenDir)) {
                p[0] = path;
                p[1] = cpe.getOutputLocation() != null ? cpe.getOutputLocation() : jproj.getOutputLocation();
                paths.add(p);
            }
            ++i;
        }
        return (IPath[][])paths.toArray((T[])new IPath[paths.size()][2]);
    }

    public static void markGeneratedFilesAsDerived(IFolder outputFolder) throws CoreException {
        EJBCoreUtil.markGeneratedFilesAsDerived(outputFolder, Collections.EMPTY_SET, null);
    }

    public static void markGeneratedFilesAsDerived(IFolder outputFolder, final Set<IResource> existingResources, final String ignoreFilesRegexp) throws CoreException {
        outputFolder.accept(new IResourceVisitor(){
            Pattern pattern = null;

            public boolean visit(IResource resource) throws CoreException {
                if (!(existingResources.contains(resource) || this.ignore(resource.getName()) || resource.isDerived())) {
                    resource.setDerived(true);
                }
                return resource instanceof IContainer;
            }

            private boolean ignore(String resourceName) {
                if (ignoreFilesRegexp == null) {
                    return false;
                }
                if (this.pattern == null) {
                    try {
                        this.pattern = Pattern.compile(ignoreFilesRegexp);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        return true;
                    }
                }
                return this.pattern.matcher(resourceName).matches();
            }
        });
    }

    public static boolean isEJBGenSrc(IFile file) throws CoreException {
        IContentType contentType;
        IContentDescription description = file.getContentDescription();
        return description != null && (contentType = file.getContentDescription().getContentType()).getId().startsWith(EJB_CONTENT_TYPE_ID_PREFIX);
    }

    public static IMarker createMarker(IResource resource, int severity, String msg) throws CoreException {
        IMarker marker = resource.createMarker(EJBGEN_PROBLEM);
        marker.setAttribute("severity", severity);
        marker.setAttribute("message", (Object)msg);
        return marker;
    }

    public static void deleteGeneratedDDs(final IProject project, final EjbJarHandling ejbJarHandling) throws CoreException {
        IPath[] srcPaths = EJBCoreUtil.getEJBSrcPath(JavaCore.create((IProject)project));
        if (srcPaths.length == 0) {
            return;
        }
        IFolder metaInfFolder = project.getFolder(srcPaths[0].append("META-INF"));
        if (!metaInfFolder.exists()) {
            return;
        }
        metaInfFolder.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (!(resource instanceof IFile)) {
                    return true;
                }
                IFile file = (IFile)resource;
                if (resource.isDerived()) {
                    if (file.getName().equals("ejb-jar.xml") && ejbJarHandling != EjbJarHandling.DELETE) {
                        IStatus status;
                        if (ejbJarHandling == EjbJarHandling.MAKE_WRITEABLE && file.isReadOnly() && !(status = project.getWorkspace().validateEdit(new IFile[]{file}, null)).isOK()) {
                            EJBCoreUtil.createMarker((IResource)project, 2, NLS.bind((String)EJBProjectMessages.ejbJarXmlReadOnly, (Object)file.getProjectRelativePath()));
                        }
                        return false;
                    }
                    resource.delete(true, null);
                }
                return false;
            }
        });
    }

    public static enum EjbJarHandling {
        DELETE,
        LEAVE,
        MAKE_WRITEABLE;

    }
}

