/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.operations.internal;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.DataSourceType;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.jdbc.JDBCInfoFactoryUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class CreateJdbcDataSourceValidator
extends ValidationService {
    protected Status compute() {
        Value dataSourceType = (Value)this.context(Value.class);
        try {
            Version wlsVersionEx;
            WebLogicServerVersion wlsVersion;
            IRuntime rt;
            IFacetedProject facetedProj;
            IProject project;
            if (dataSourceType.content() == DataSourceType.GridLinkDataSource && (project = (IProject)dataSourceType.element().adapt(IProject.class)) != null && (facetedProj = ProjectFacetsManager.create((IProject)project)) != null && (rt = facetedProj.getPrimaryRuntime()) != null && (wlsVersion = JDBCInfoFactoryUtil.getWlsRuntimeVersion(rt)) != null && !(wlsVersionEx = new Version(wlsVersion.getVersionString())).matches("[10.3.4")) {
                return Status.createErrorStatus((String)Resources.invalidDataSourceType);
            }
        }
        catch (CoreException ce) {
            LoggingService.logException((Plugin)WlsCorePlugin.getInstance(), (CoreException)ce);
        }
        return Status.createOkStatus();
    }

    private static final class Resources
    extends NLS {
        public static String invalidDataSourceType;

        static {
            Resources.initializeMessages((String)CreateJdbcDataSourceValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

