/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms.internal;

import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJmsModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.jms.INamedEntity;
import oracle.eclipse.tools.weblogic.descriptors.jms.ISAFImportedDestinations;
import oracle.eclipse.tools.weblogic.descriptors.jms.ISAFQueue;
import oracle.eclipse.tools.weblogic.descriptors.jms.ISAFTopic;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.ValidatorResources;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class UniqueSafDestinationNameValidator
extends ValidationService {
    private Listener listener;

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                UniqueSafDestinationNameValidator.this.refresh();
            }
        };
        IWebLogicJmsModuleDescriptor descriptor = (IWebLogicJmsModuleDescriptor)this.context(IWebLogicJmsModuleDescriptor.class);
        descriptor.attach(this.listener, "/SafImportedDestinations/SafQueues/Name");
        descriptor.attach(this.listener, "/SafImportedDestinations/SafTopics/Name");
    }

    public void dispose() {
        super.dispose();
        IWebLogicJmsModuleDescriptor descriptor = (IWebLogicJmsModuleDescriptor)this.context(IWebLogicJmsModuleDescriptor.class);
        descriptor.detach(this.listener, "/SafImportedDestinations/SafQueues/Name");
        descriptor.detach(this.listener, "/SafImportedDestinations/SafTopics/Name");
    }

    protected Status compute() {
        Element descriptor;
        Value value = (Value)this.context(Value.class);
        String str = value.text();
        if (str != null && (descriptor = value.root()) instanceof IWebLogicJmsModuleDescriptor) {
            IWebLogicJmsModuleDescriptor jmsDescriptor = (IWebLogicJmsModuleDescriptor)descriptor;
            INamedEntity thisNamedEntity = (INamedEntity)value.element().nearest(INamedEntity.class);
            if (thisNamedEntity != null) {
                for (ISAFImportedDestinations safDestination : jmsDescriptor.getSafImportedDestinations()) {
                    for (ISAFQueue queue : safDestination.getSafQueues()) {
                        if (thisNamedEntity == queue || !str.equals(queue.getName().text())) continue;
                        return Status.createErrorStatus((String)ValidatorResources.bind((String)ValidatorResources.uniqueNameError, (Object)str));
                    }
                    for (ISAFTopic topic : safDestination.getSafTopics()) {
                        if (thisNamedEntity == topic || !str.equals(topic.getName().text())) continue;
                        return Status.createErrorStatus((String)ValidatorResources.bind((String)ValidatorResources.uniqueNameError, (Object)str));
                    }
                }
            }
        }
        return Status.createOkStatus();
    }
}

