/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms.internal;

import java.util.Set;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJmsModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.jms.IGroupParams;
import oracle.eclipse.tools.weblogic.descriptors.jms.IQueue;
import oracle.eclipse.tools.weblogic.descriptors.jms.IQueueBase;
import oracle.eclipse.tools.weblogic.descriptors.jms.ITopic;
import oracle.eclipse.tools.weblogic.descriptors.jms.ITopicBase;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.ValidatorResources;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.services.PossibleValuesService;

public class SubdeploymentValuesProvider
extends PossibleValuesService {
    private Listener listener;

    protected void init() {
        super.init();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                SubdeploymentValuesProvider.this.broadcast();
            }
        };
        IWebLogicJmsModuleDescriptor descriptor = (IWebLogicJmsModuleDescriptor)this.context(IWebLogicJmsModuleDescriptor.class);
        descriptor.attach(this.listener, "/Queues[#type=IQueue]/SubDeploymentName");
        descriptor.attach(this.listener, "/Topics[#type=ITopic]/SubDeploymentName");
        IGroupParams groupParams = (IGroupParams)this.context(IGroupParams.class);
        groupParams.attach(this.listener, "*/SubDeploymentName");
        groupParams.attach(this.listener, "ErrorDestination");
    }

    public void dispose() {
        super.dispose();
        IWebLogicJmsModuleDescriptor descriptor = (IWebLogicJmsModuleDescriptor)this.context(IWebLogicJmsModuleDescriptor.class);
        descriptor.detach(this.listener, "/Queues[#type=IQueue]/SubDeploymentName");
        descriptor.detach(this.listener, "/Topics[#type=ITopic]/SubDeploymentName");
        IGroupParams groupParams = (IGroupParams)this.context(IGroupParams.class);
        if (groupParams != null && !groupParams.disposed()) {
            groupParams.detach(this.listener, "*/SubDeploymentName");
            groupParams.detach(this.listener, "ErrorDestination");
        }
    }

    protected void fillPossibleValues(Set<String> values) {
        String subdeployment = this.getSubdeployment();
        if (subdeployment != null) {
            values.add(subdeployment);
        }
    }

    private String getSubdeployment() {
        Element descriptor;
        String subdeployment = null;
        IGroupParams params = (IGroupParams)this.context(IGroupParams.class);
        String errorDestination = params.getErrorDestination().text();
        if (errorDestination != null && errorDestination.length() > 0 && (descriptor = params.root()) instanceof IWebLogicJmsModuleDescriptor) {
            IWebLogicJmsModuleDescriptor jmsDescriptor = (IWebLogicJmsModuleDescriptor)descriptor;
            for (IQueueBase queue : jmsDescriptor.getQueues()) {
                if (queue.type() != IQueue.TYPE || !errorDestination.equals(queue.getName().text())) continue;
                subdeployment = ((IQueue)queue).getSubDeploymentName().text();
                break;
            }
            if (subdeployment == null) {
                for (ITopicBase topic : jmsDescriptor.getTopics()) {
                    if (topic.type() != ITopic.TYPE || !errorDestination.equals(topic.getName().text())) continue;
                    subdeployment = ((ITopic)topic).getSubDeploymentName().text();
                    break;
                }
            }
        }
        return subdeployment;
    }

    public String getInvalidValueMessage(String invalidValue) {
        String subdeployment;
        IGroupParams params = (IGroupParams)this.context(IGroupParams.class);
        String errorDestination = params.getErrorDestination().text();
        if (errorDestination != null && errorDestination.length() > 0 && (subdeployment = this.getSubdeployment()) != null) {
            return ValidatorResources.bind((String)ValidatorResources.diffSubdeployment, (Object)errorDestination, (Object)subdeployment);
        }
        return ValidatorResources.bind((String)ValidatorResources.invalidSubdeployment, (Object)invalidValue);
    }
}

