/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms.internal;

import java.util.Set;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJmsModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.jms.ISAFImportedDestinations;
import oracle.eclipse.tools.weblogic.descriptors.jms.ISAFQueue;
import oracle.eclipse.tools.weblogic.descriptors.jms.ISAFTopic;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.services.PossibleValuesService;

public class SAFErrorDestinationValuesProvider
extends PossibleValuesService {
    private Listener listener;

    protected void init() {
        super.init();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                SAFErrorDestinationValuesProvider.this.broadcast();
            }
        };
        IWebLogicJmsModuleDescriptor descriptor = (IWebLogicJmsModuleDescriptor)this.context(IWebLogicJmsModuleDescriptor.class);
        descriptor.attach(this.listener, "/SafImportedDestinations/SafQueues/Name");
        descriptor.attach(this.listener, "/SafImportedDestinations/SafTopics/Name");
    }

    public void dispose() {
        super.dispose();
        IWebLogicJmsModuleDescriptor descriptor = (IWebLogicJmsModuleDescriptor)this.context(IWebLogicJmsModuleDescriptor.class);
        descriptor.detach(this.listener, "/SafImportedDestinations/SafQueues/Name");
        descriptor.detach(this.listener, "/SafImportedDestinations/SafTopics/Name");
    }

    protected void fillPossibleValues(Set<String> values) {
        Element descriptor = ((Element)this.context(Element.class)).root();
        if (descriptor instanceof IWebLogicJmsModuleDescriptor) {
            IWebLogicJmsModuleDescriptor jmsDescriptor = (IWebLogicJmsModuleDescriptor)descriptor;
            for (ISAFImportedDestinations safDest : jmsDescriptor.getSafImportedDestinations()) {
                String name;
                for (ISAFQueue safQueue : safDest.getSafQueues()) {
                    name = safQueue.getName().text();
                    if (name == null) continue;
                    values.add(name);
                }
                for (ISAFTopic safTopic : safDest.getSafTopics()) {
                    name = safTopic.getName().text();
                    if (name == null) continue;
                    values.add(safTopic.getName().text());
                }
            }
        }
    }
}

