/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms.internal;

import oracle.eclipse.tools.weblogic.descriptors.jms.IMessageLoggingFormatPart;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.ImageService;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;

public final class MessageLoggingFormatPartImageService
extends ImageService {
    private static final ImageData IMG_BODY = (ImageData)ImageData.readFromClassLoader(MessageLoggingFormatPartImageService.class, (String)"images/descriptors/jms/message-body.png").required();
    private static final ImageData IMG_HEADERS = (ImageData)ImageData.readFromClassLoader(MessageLoggingFormatPartImageService.class, (String)"images/descriptors/jms/message-header.png").required();
    private static final ImageData IMG_PROPERTY = (ImageData)ImageData.readFromClassLoader(MessageLoggingFormatPartImageService.class, (String)"images/descriptors/jms/message-property.png").required();
    private static final ImageData IMG_PROPERTY_CUSTOM = (ImageData)ImageData.readFromClassLoader(MessageLoggingFormatPartImageService.class, (String)"images/descriptors/jms/message-custom-property.png").required();
    private Listener listener;

    protected void initImageService() {
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                MessageLoggingFormatPartImageService.this.refresh();
            }
        };
        ((IMessageLoggingFormatPart)this.context(IMessageLoggingFormatPart.class)).getName().attach(this.listener);
    }

    protected ImageData compute() {
        String entry = ((IMessageLoggingFormatPart)this.context(IMessageLoggingFormatPart.class)).getName().text();
        if (entry != null) {
            if ("%body%".equals(entry)) {
                return IMG_BODY;
            }
            if ("%header%".equals(entry) || IMessageLoggingFormatPart.SYSTEM_HEADERS.contains(entry)) {
                return IMG_HEADERS;
            }
            if ("%properties%".equals(entry) || IMessageLoggingFormatPart.SYSTEM_PROPERTIES.contains(entry)) {
                return IMG_PROPERTY;
            }
        }
        return IMG_PROPERTY_CUSTOM;
    }

    public void dispose() {
        super.dispose();
        ((IMessageLoggingFormatPart)this.context(IMessageLoggingFormatPart.class)).getName().detach(this.listener);
    }
}

