/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms.internal;

import oracle.eclipse.tools.common.util.ObjectUtil;
import oracle.eclipse.tools.weblogic.descriptors.jms.IForeignJndiObject;
import oracle.eclipse.tools.weblogic.descriptors.jms.IForeignServer;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.JndiNameValidator;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.ValidatorResources;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Status;

public class LocalJndiNameValidator
extends JndiNameValidator {
    private String propName;
    private boolean validateLocalJndi;
    private Listener listener;

    @Override
    protected void initValidationService() {
        super.initValidationService();
        this.propName = this.param("property");
        this.validateLocalJndi = Boolean.parseBoolean(this.param("validateLocalJndi"));
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                LocalJndiNameValidator.this.refresh();
            }
        };
        IForeignJndiObject foreignJndi = (IForeignJndiObject)this.context(IForeignJndiObject.class);
        foreignJndi.attach(this.listener, this.propName);
        foreignJndi.attach(this.listener, "../ConnectionUrl");
    }

    @Override
    public void dispose() {
        super.dispose();
        IForeignJndiObject foreignJndi = (IForeignJndiObject)this.context(IForeignJndiObject.class);
        if (foreignJndi != null && !foreignJndi.disposed()) {
            foreignJndi.attach(this.listener, this.propName);
            foreignJndi.attach(this.listener, "../ConnectionUrl");
        }
    }

    @Override
    protected Status compute() {
        String otherJndiName;
        ElementType type;
        PropertyDef prop;
        Property obj;
        Value value = (Value)this.context(Value.class);
        Element element = value.element();
        ValueProperty property = value.definition();
        String jndiName = value.text();
        if (this.propName != null && !this.hasConnectionUrl(element) && jndiName != null && jndiName.length() > 0 && (obj = element.property(prop = (type = element.type()).property(this.propName))) instanceof Value && ObjectUtil.areEqual((Object)jndiName, (Object)(otherJndiName = ((Value)obj).text()))) {
            Object[] params = new String[]{property.getLabel(false, CapitalizationType.FIRST_WORD_ONLY, false), prop.getLabel(false, CapitalizationType.NO_CAPS, false)};
            return Status.createErrorStatus((String)ValidatorResources.bind((String)ValidatorResources.jndiDifferent, (Object[])params));
        }
        if (this.validateLocalJndi) {
            return super.compute();
        }
        return Status.createOkStatus();
    }

    private boolean hasConnectionUrl(Element element) {
        String connectionUrl;
        return (element = element.parent().element()) instanceof IForeignServer && (connectionUrl = ((IForeignServer)element).getConnectionUrl().text(false)) != null && connectionUrl.length() > 0;
    }
}

