/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms.internal;

import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJmsModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.jms.ICommonDestination;
import oracle.eclipse.tools.weblogic.descriptors.jms.IConnectionFactory;
import oracle.eclipse.tools.weblogic.descriptors.jms.IDistributedDestination;
import oracle.eclipse.tools.weblogic.descriptors.jms.IForeignConnectionFactory;
import oracle.eclipse.tools.weblogic.descriptors.jms.IForeignJndiObject;
import oracle.eclipse.tools.weblogic.descriptors.jms.IForeignServer;
import oracle.eclipse.tools.weblogic.descriptors.jms.INamedEntity;
import oracle.eclipse.tools.weblogic.descriptors.jms.IQueueBase;
import oracle.eclipse.tools.weblogic.descriptors.jms.ITopicBase;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.ValidatorResources;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class JndiNameValidator
extends ValidationService {
    private Listener listener;

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                JndiNameValidator.this.refresh();
            }
        };
        IWebLogicJmsModuleDescriptor descriptor = (IWebLogicJmsModuleDescriptor)this.context(IWebLogicJmsModuleDescriptor.class);
        descriptor.attach(this.listener, "/Queues/JndiName");
        descriptor.attach(this.listener, "/Topics/JndiName");
        descriptor.attach(this.listener, "/ConnectionFactories/JndiName");
        descriptor.attach(this.listener, "/ForeignServers/ForeignDestinations/LocalJndiName");
        descriptor.attach(this.listener, "/ForeignServers/ForeignConnectionFactories/LocalJndiName");
    }

    public void dispose() {
        super.dispose();
        IWebLogicJmsModuleDescriptor descriptor = (IWebLogicJmsModuleDescriptor)this.context(IWebLogicJmsModuleDescriptor.class);
        descriptor.detach(this.listener, "/Queues/JndiName");
        descriptor.detach(this.listener, "/Topics/JndiName");
        descriptor.detach(this.listener, "/ConnectionFactories/JndiName");
        descriptor.detach(this.listener, "/ForeignServers/ForeignDestinations/LocalJndiName");
        descriptor.detach(this.listener, "/ForeignServers/ForeignConnectionFactories/LocalJndiName");
    }

    protected Status compute() {
        Value value = (Value)this.context(Value.class);
        String jndiName = value.text();
        INamedEntity nameEntity = (INamedEntity)value.element().nearest(INamedEntity.class);
        if (jndiName == null || jndiName.length() == 0) {
            return Status.createWarningStatus((String)ValidatorResources.useJndi);
        }
        Element descriptor = value.root();
        if (descriptor instanceof IWebLogicJmsModuleDescriptor) {
            Object dest;
            String name;
            IWebLogicJmsModuleDescriptor jmsDescriptor = (IWebLogicJmsModuleDescriptor)descriptor;
            for (IQueueBase queue : jmsDescriptor.getQueues()) {
                if (nameEntity.equals(queue) || !(queue instanceof ICommonDestination ? jndiName.equals(name = (dest = (ICommonDestination)((Object)queue)).getJndiName().text()) : queue instanceof IDistributedDestination && jndiName.equals(name = (dest = (IDistributedDestination)((Object)queue)).getJndiName().text()))) continue;
                return Status.createWarningStatus((String)ValidatorResources.bind((String)ValidatorResources.sameJndi, (Object)queue.getName().text()));
            }
            for (ITopicBase topic : jmsDescriptor.getTopics()) {
                if (nameEntity.equals(topic) || !(topic instanceof ICommonDestination ? jndiName.equals(name = (dest = (ICommonDestination)((Object)topic)).getJndiName().text()) : topic instanceof IDistributedDestination && jndiName.equals(name = (dest = (IDistributedDestination)((Object)topic)).getJndiName().text()))) continue;
                return Status.createWarningStatus((String)ValidatorResources.bind((String)ValidatorResources.sameJndi, (Object)topic.getName().text()));
            }
            for (IConnectionFactory connectionFactory : jmsDescriptor.getConnectionFactories()) {
                String name2;
                if (nameEntity.equals(connectionFactory) || !jndiName.equals(name2 = connectionFactory.getJndiName().text())) continue;
                return Status.createWarningStatus((String)ValidatorResources.bind((String)ValidatorResources.sameJndi, (Object)connectionFactory.getName().text()));
            }
            for (IForeignServer server : jmsDescriptor.getForeignServers()) {
                String name3;
                for (IForeignJndiObject foreignJndi : server.getForeignDestinations()) {
                    if (nameEntity.equals(foreignJndi) || !jndiName.equals(name3 = foreignJndi.getLocalJndiName().text())) continue;
                    return Status.createWarningStatus((String)ValidatorResources.bind((String)ValidatorResources.sameJndi, (Object)foreignJndi.getName().text()));
                }
                for (IForeignConnectionFactory foreignConnectionFactory : server.getForeignConnectionFactories()) {
                    if (nameEntity.equals(foreignConnectionFactory) || !jndiName.equals(name3 = foreignConnectionFactory.getLocalJndiName().text())) continue;
                    return Status.createWarningStatus((String)ValidatorResources.bind((String)ValidatorResources.sameJndi, (Object)foreignConnectionFactory.getName().text()));
                }
            }
        }
        return Status.createOkStatus();
    }
}

