/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms.internal;

import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJmsModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.jms.IQueue;
import oracle.eclipse.tools.weblogic.descriptors.jms.IQueueBase;
import oracle.eclipse.tools.weblogic.descriptors.jms.ITopic;
import oracle.eclipse.tools.weblogic.descriptors.jms.ITopicBase;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.ValidatorResources;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class ErrorDestinationSubdeploymentValidator
extends ValidationService {
    protected Status compute() {
        Value value = (Value)this.context(Value.class);
        String errorDestination = value.text();
        boolean validDestination = false;
        if (errorDestination != null && errorDestination.length() > 0) {
            String subdeployment = null;
            Element descriptor = value.root();
            if (descriptor instanceof IWebLogicJmsModuleDescriptor) {
                IWebLogicJmsModuleDescriptor jmsDescriptor = (IWebLogicJmsModuleDescriptor)descriptor;
                for (IQueueBase queue : jmsDescriptor.getQueues()) {
                    if (queue.type() != IQueue.TYPE || !errorDestination.equals(queue.getName().text())) continue;
                    validDestination = true;
                    subdeployment = ((IQueue)queue).getSubDeploymentName().text();
                    break;
                }
                if (subdeployment == null) {
                    for (ITopicBase topic : jmsDescriptor.getTopics()) {
                        if (topic.type() != ITopic.TYPE || !errorDestination.equals(topic.getName().text())) continue;
                        validDestination = true;
                        subdeployment = ((ITopic)topic).getSubDeploymentName().text();
                        break;
                    }
                }
            }
            if (!validDestination) {
                return Status.createErrorStatus((String)ValidatorResources.bind((String)ValidatorResources.invalidErrorDestination, (Object)errorDestination));
            }
            if (subdeployment == null) {
                return Status.createErrorStatus((String)ValidatorResources.bind((String)ValidatorResources.emptySubdeployment, (Object)errorDestination));
            }
        }
        return Status.createOkStatus();
    }
}

