/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms.internal;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJmsModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.jms.IDestinationTemplate;
import oracle.eclipse.tools.weblogic.descriptors.jms.IGroupParams;
import oracle.eclipse.tools.weblogic.descriptors.jms.IQueue;
import oracle.eclipse.tools.weblogic.descriptors.jms.IQueueBase;
import oracle.eclipse.tools.weblogic.descriptors.jms.ITopic;
import oracle.eclipse.tools.weblogic.descriptors.jms.ITopicBase;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.ValidatorResources;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class ErrorDestinationSubdeploymentNameValidator
extends ValidationService {
    private Listener listener;

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                ErrorDestinationSubdeploymentNameValidator.this.refresh();
            }
        };
        IWebLogicJmsModuleDescriptor descriptor = (IWebLogicJmsModuleDescriptor)this.context(IWebLogicJmsModuleDescriptor.class);
        descriptor.attach(this.listener, "/Queues[#type=IQueue]/SubDeploymentName");
        descriptor.attach(this.listener, "/Topics[#type=ITopic]/SubDeploymentName");
        descriptor.attach(this.listener, "/Queues[#type=IQueue]/Template");
        descriptor.attach(this.listener, "/Topics[#type=ITopic]/Template");
        IGroupParams groupParams = (IGroupParams)this.context(IGroupParams.class);
        groupParams.attach(this.listener, "*/SubDeploymentName");
        groupParams.attach(this.listener, "ErrorDestination");
    }

    public void dispose() {
        super.dispose();
        IWebLogicJmsModuleDescriptor descriptor = (IWebLogicJmsModuleDescriptor)this.context(IWebLogicJmsModuleDescriptor.class);
        descriptor.detach(this.listener, "/Queues[#type=IQueue]/SubDeploymentName");
        descriptor.detach(this.listener, "/Topics[#type=ITopic]/SubDeploymentName");
        descriptor.detach(this.listener, "/Queues[#type=IQueue]/Template");
        descriptor.detach(this.listener, "/Topics[#type=ITopic]/Template");
        IGroupParams groupParams = (IGroupParams)this.context(IGroupParams.class);
        if (groupParams != null && !groupParams.disposed()) {
            groupParams.detach(this.listener, "*/SubDeploymentName");
            groupParams.detach(this.listener, "ErrorDestination");
        }
    }

    protected Status compute() {
        String templateName;
        Value value = (Value)this.context(Value.class);
        IDestinationTemplate template = (IDestinationTemplate)value.element().nearest(IDestinationTemplate.class);
        String string = templateName = template != null ? template.getName().text() : null;
        if (templateName != null && templateName.length() > 0) {
            List<String> subdeployments = this.getSubdeployments(template);
            Element descriptor = value.root();
            if (descriptor instanceof IWebLogicJmsModuleDescriptor) {
                IWebLogicJmsModuleDescriptor jmsDescriptor = (IWebLogicJmsModuleDescriptor)descriptor;
                for (IQueueBase queue : jmsDescriptor.getQueues()) {
                    String queueSubdeployment;
                    if (queue.type() != IQueue.TYPE || !templateName.equals(((IQueue)queue).getTemplate().text()) || subdeployments.contains(queueSubdeployment = ((IQueue)queue).getSubDeploymentName().text())) continue;
                    return Status.createErrorStatus((String)ValidatorResources.bind((String)ValidatorResources.templateDestinationSubdeploymentError, (Object)queue.getName().text()));
                }
                for (ITopicBase topic : jmsDescriptor.getTopics()) {
                    String topicSubdeployment;
                    if (topic.type() != ITopic.TYPE || !templateName.equals(((ITopic)topic).getTemplate().text()) || subdeployments.contains(topicSubdeployment = ((ITopic)topic).getSubDeploymentName().text())) continue;
                    return Status.createErrorStatus((String)ValidatorResources.bind((String)ValidatorResources.templateDestinationSubdeploymentError, (Object)topic.getName().text()));
                }
            }
        }
        return Status.createOkStatus();
    }

    private List<String> getSubdeployments(IDestinationTemplate template) {
        ArrayList<String> subdeployments = new ArrayList<String>();
        for (IGroupParams param : template.getGroupParams()) {
            String name = param.getSubDeploymentName().text();
            if (name == null || name.length() <= 0) continue;
            subdeployments.add(name);
        }
        return subdeployments;
    }
}

