/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms.internal;

import oracle.eclipse.tools.common.util.ObjectUtil;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJmsModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.jms.ExpirationPolicy;
import oracle.eclipse.tools.weblogic.descriptors.jms.ICommonDestination;
import oracle.eclipse.tools.weblogic.descriptors.jms.IDeliveryFailureParamsBase;
import oracle.eclipse.tools.weblogic.descriptors.jms.IQueue;
import oracle.eclipse.tools.weblogic.descriptors.jms.IQueueBase;
import oracle.eclipse.tools.weblogic.descriptors.jms.ITopic;
import oracle.eclipse.tools.weblogic.descriptors.jms.ITopicBase;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.ValidatorResources;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class DestinationValuesValidator
extends ValidationService {
    private Listener listener;

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                DestinationValuesValidator.this.refresh();
            }
        };
        IWebLogicJmsModuleDescriptor descriptor = (IWebLogicJmsModuleDescriptor)this.context(IWebLogicJmsModuleDescriptor.class);
        descriptor.attach(this.listener, "/Queues/Name");
        descriptor.attach(this.listener, "/Queues[#type=IQueue]/SubDeploymentName");
        descriptor.attach(this.listener, "/Topics/Name");
        descriptor.attach(this.listener, "/Topics[#type=ITopic]/SubDeploymentName");
        ((IDeliveryFailureParamsBase)this.context(IDeliveryFailureParamsBase.class)).getExpirationPolicy().attach(this.listener);
    }

    public void dispose() {
        super.dispose();
        IWebLogicJmsModuleDescriptor descriptor = (IWebLogicJmsModuleDescriptor)this.context(IWebLogicJmsModuleDescriptor.class);
        descriptor.detach(this.listener, "/Queues/Name");
        descriptor.detach(this.listener, "/Queues[#type=IQueue]/SubDeploymentName");
        descriptor.detach(this.listener, "/Topics/Name");
        descriptor.detach(this.listener, "/Topics[#type=ITopic]/SubDeploymentName");
        IDeliveryFailureParamsBase failureParams = (IDeliveryFailureParamsBase)this.context(IDeliveryFailureParamsBase.class);
        if (failureParams != null && !failureParams.disposed()) {
            failureParams.getExpirationPolicy().detach(this.listener);
        }
    }

    protected Status compute() {
        Element descriptor;
        Value value = (Value)this.context(Value.class);
        String dest = value.text();
        IDeliveryFailureParamsBase deliveryFailure = (IDeliveryFailureParamsBase)value.element().nearest(IDeliveryFailureParamsBase.class);
        String subdeployment = null;
        boolean isTargetable = false;
        if (deliveryFailure != null) {
            if (deliveryFailure.getExpirationPolicy().content() == ExpirationPolicy.REDIRECT && dest == null) {
                String labelText = value.definition().getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false);
                return Status.createErrorStatus((String)ValidatorResources.bind((String)ValidatorResources.nullValueError, (Object)labelText));
            }
            ICommonDestination destination = (ICommonDestination)deliveryFailure.nearest(ICommonDestination.class);
            if (destination != null) {
                subdeployment = destination.getSubDeploymentName().text();
                isTargetable = true;
            }
        }
        if (dest != null && isTargetable && (descriptor = value.root()) instanceof IWebLogicJmsModuleDescriptor) {
            String subdeployment2;
            String name;
            IWebLogicJmsModuleDescriptor jmsDescriptor = (IWebLogicJmsModuleDescriptor)descriptor;
            for (IQueueBase queue : jmsDescriptor.getQueues()) {
                if (!this.isQueueType(queue.type()) || !dest.equals(name = queue.getName().text()) || ObjectUtil.equal((Object)subdeployment, (Object)(subdeployment2 = ((ICommonDestination)((Object)queue)).getSubDeploymentName().text()))) continue;
                return Status.createErrorStatus((String)ValidatorResources.destinationSameSubdeployomentError);
            }
            for (ITopicBase topic : jmsDescriptor.getTopics()) {
                if (!this.isTopicType(topic.type()) || !dest.equals(name = topic.getName().text()) || ObjectUtil.equal((Object)subdeployment, (Object)(subdeployment2 = ((ICommonDestination)((Object)topic)).getSubDeploymentName().text()))) continue;
                return Status.createErrorStatus((String)ValidatorResources.destinationSameSubdeployomentError);
            }
        }
        return Status.createOkStatus();
    }

    protected boolean isQueueType(ElementType type) {
        return type == IQueue.TYPE;
    }

    protected boolean isTopicType(ElementType type) {
        return type == ITopic.TYPE;
    }
}

