/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms.internal;

import java.util.Set;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJmsModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.jms.ICommonDestination;
import oracle.eclipse.tools.weblogic.descriptors.jms.IQueue;
import oracle.eclipse.tools.weblogic.descriptors.jms.IQueueBase;
import oracle.eclipse.tools.weblogic.descriptors.jms.ITopic;
import oracle.eclipse.tools.weblogic.descriptors.jms.ITopicBase;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.services.PossibleValuesService;

public class DestinationValuesProvider
extends PossibleValuesService {
    private Listener listener;

    protected void init() {
        super.init();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                DestinationValuesProvider.this.broadcast();
            }
        };
        IWebLogicJmsModuleDescriptor descriptor = (IWebLogicJmsModuleDescriptor)this.context(IWebLogicJmsModuleDescriptor.class);
        descriptor.attach(this.listener, "/Queues/Name");
        descriptor.attach(this.listener, "/Topics/Name");
    }

    public void dispose() {
        super.dispose();
        IWebLogicJmsModuleDescriptor descriptor = (IWebLogicJmsModuleDescriptor)this.context(IWebLogicJmsModuleDescriptor.class);
        descriptor.detach(this.listener, "/Queues/Name");
        descriptor.detach(this.listener, "/Topics/Name");
    }

    protected void fillPossibleValues(Set<String> values) {
        Element descriptor;
        ICommonDestination thisDestination = null;
        if (((Element)this.context(Element.class)).parent() instanceof ICommonDestination) {
            thisDestination = (ICommonDestination)((Element)this.context(Element.class)).parent();
        }
        if ((descriptor = ((Element)this.context(Element.class)).root()) instanceof IWebLogicJmsModuleDescriptor) {
            String name;
            IWebLogicJmsModuleDescriptor jmsDescriptor = (IWebLogicJmsModuleDescriptor)descriptor;
            for (IQueueBase queue : jmsDescriptor.getQueues()) {
                if (queue.type() != IQueue.TYPE || queue.equals(thisDestination) || (name = queue.getName().text()) == null || name.length() <= 0) continue;
                values.add(name);
            }
            for (ITopicBase topic : jmsDescriptor.getTopics()) {
                if (topic.type() != ITopic.TYPE || topic.equals(thisDestination) || (name = topic.getName().text()) == null || name.length() <= 0) continue;
                values.add(name);
            }
        }
    }
}

