/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms.internal;

import java.util.Set;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJmsModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.jms.IConnectionFactory;
import oracle.eclipse.tools.weblogic.descriptors.jms.IForeignServer;
import oracle.eclipse.tools.weblogic.descriptors.jms.IQueue;
import oracle.eclipse.tools.weblogic.descriptors.jms.IQueueBase;
import oracle.eclipse.tools.weblogic.descriptors.jms.ISAFImportedDestinations;
import oracle.eclipse.tools.weblogic.descriptors.jms.ITargetable;
import oracle.eclipse.tools.weblogic.descriptors.jms.ITopic;
import oracle.eclipse.tools.weblogic.descriptors.jms.ITopicBase;
import oracle.eclipse.tools.weblogic.descriptors.jms.IUniformDistributedQueue;
import oracle.eclipse.tools.weblogic.descriptors.jms.IUniformDistributedTopic;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.PossibleValuesService;

public class DeploymentNameValuesProvider
extends PossibleValuesService {
    private Listener listener;

    protected void init() {
        super.init();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                DeploymentNameValuesProvider.this.broadcast();
            }
        };
        IWebLogicJmsModuleDescriptor descriptor = (IWebLogicJmsModuleDescriptor)this.context(IWebLogicJmsModuleDescriptor.class);
        descriptor.attach(this.listener, "/Queues[#type=IQueue]/SubDeploymentName");
        descriptor.attach(this.listener, "/Queues[#type=IUniformDistributedQueue]/SubDeploymentName");
        descriptor.attach(this.listener, "/Topics[#type=ITopic]/SubDeploymentName");
        descriptor.attach(this.listener, "/Topics[#type=IUniformDistributedTopic]/SubDeploymentName");
        descriptor.attach(this.listener, "/SafImportedDestinations/SubDeploymentName");
        descriptor.attach(this.listener, "/ConnectionFactories/SubDeploymentName");
        descriptor.attach(this.listener, "/ForeignServers/SubDeploymentName");
    }

    public void dispose() {
        super.dispose();
        IWebLogicJmsModuleDescriptor descriptor = (IWebLogicJmsModuleDescriptor)this.context(IWebLogicJmsModuleDescriptor.class);
        descriptor.detach(this.listener, "/Queues[#type=IQueue]/SubDeploymentName");
        descriptor.detach(this.listener, "/Queues[#type=IUniformDistributedQueue]/SubDeploymentName");
        descriptor.detach(this.listener, "/Topics[#type=ITopic]/SubDeploymentName");
        descriptor.detach(this.listener, "/Topics[#type=IUniformDistributedTopic]/SubDeploymentName");
        descriptor.detach(this.listener, "/SafImportedDestinations/SubDeploymentName");
        descriptor.detach(this.listener, "/ConnectionFactories/SubDeploymentName");
        descriptor.detach(this.listener, "/ForeignServers/SubDeploymentName");
    }

    public Status.Severity getInvalidValueSeverity(String invalidValue) {
        return Status.Severity.OK;
    }

    protected void fillPossibleValues(Set<String> values) {
        Element descriptor = ((Element)this.context(Element.class)).root();
        if (descriptor instanceof IWebLogicJmsModuleDescriptor) {
            String deploymentName;
            ITargetable targetable;
            String deploymentName2;
            IWebLogicJmsModuleDescriptor jmsDescriptor = (IWebLogicJmsModuleDescriptor)descriptor;
            Element element = (Element)this.context(Element.class);
            for (IQueueBase queue : jmsDescriptor.getQueues()) {
                if (queue.equals(element) || queue.type() != IQueue.TYPE && queue.type() != IUniformDistributedQueue.TYPE || (deploymentName2 = (targetable = (ITargetable)((Object)queue)).getSubDeploymentName().text()) == null || deploymentName2.length() <= 0 || values.contains(deploymentName2)) continue;
                values.add(deploymentName2);
            }
            for (ITopicBase topic : jmsDescriptor.getTopics()) {
                if (topic.equals(element) || topic.type() != ITopic.TYPE && topic.type() != IUniformDistributedTopic.TYPE || (deploymentName2 = (targetable = (ITargetable)((Object)topic)).getSubDeploymentName().text()) == null || deploymentName2.length() <= 0 || values.contains(deploymentName2)) continue;
                values.add(deploymentName2);
            }
            for (ISAFImportedDestinations importedDest : jmsDescriptor.getSafImportedDestinations()) {
                if (importedDest.equals(element) || (deploymentName = importedDest.getSubDeploymentName().text()) == null || deploymentName.length() <= 0 || values.contains(deploymentName)) continue;
                values.add(deploymentName);
            }
            for (IForeignServer server : jmsDescriptor.getForeignServers()) {
                if (server.equals(element) || (deploymentName = server.getSubDeploymentName().text()) == null || deploymentName.length() <= 0 || values.contains(deploymentName)) continue;
                values.add(deploymentName);
            }
            for (IConnectionFactory factory : jmsDescriptor.getConnectionFactories()) {
                if (factory.equals(element) || (deploymentName = factory.getSubDeploymentName().text()) == null || deploymentName.length() <= 0 || values.contains(deploymentName)) continue;
                values.add(deploymentName);
            }
        }
    }
}

