/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface ITransactionParams
extends Element {
    public static final ElementType TYPE = new ElementType(ITransactionParams.class);
    @Type(base=Long.class)
    @XmlBinding(path="transaction-params/transaction-timeout")
    @Label(standard="transacted session transaction timeout")
    @DefaultValue(text="3600")
    @NumericRange(min="0")
    @Documentation(content="The timeout value (in seconds) for all transactions on connections created with this connection factory.[pbr/]If a transacted session is still active after the timeout has elapsed, the transaction is rolled back. A value of 0 indicates that the default value will be used. If you have long-running transactions, you might want to adjust the value of this attribute to allow transactions to complete. ")
    public static final ValueProperty PROP_TRANSACTION_TIMEOUT = new ValueProperty(TYPE, "TransactionTimeout");
    @Type(base=Boolean.class)
    @XmlBinding(path="transaction-params/xa-connection-factory-enabled")
    @Label(standard="enable XA connection factory (enables JTA transaction support)")
    @DefaultValue(text="false")
    @Documentation(content="Indicates whether a XA queue or XA topic connection factory is returned, instead of a queue or topic connection factory. An XA connection factory can be used to create an XAConnection, which in turn may be used to create an XASession, which in turn may be used to obtain an XAResource for use inside a transaction manager.[pbr/]In addition, this attribute indicates whether or not a connection factory creates sessions that are JTA aware. If true, the associated message producers and message consumers look into the running thread for a transaction context. Otherwise, the current JTA transaction will be ignored.[pbr/]Note: Transacted sessions ignore the current threads transaction context in favor of their own internal transaction, regardless of the setting. This setting only affects non-transacted sessions.")
    public static final ValueProperty PROP_XA_ENABLED = new ValueProperty(TYPE, "XaEnabled");

    public Value<Long> getTransactionTimeout();

    public void setTransactionTimeout(String var1);

    public void setTransactionTimeout(Long var1);

    public Value<Boolean> getXaEnabled();

    public void setXaEnabled(String var1);

    public void setXaEnabled(Boolean var1);
}

