/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms;

import oracle.eclipse.tools.weblogic.descriptors.jms.INamedEntity;
import oracle.eclipse.tools.weblogic.descriptors.jms.ISAFLoginContext;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

@Label(standard="remote SAF context")
public interface ISAFRemoteContext
extends INamedEntity {
    public static final ElementType TYPE = new ElementType(ISAFRemoteContext.class);
    @Type(base=Integer.class)
    @XmlBinding(path="compression-threshold")
    @Label(standard="compression threshold")
    @NumericRange(min="0")
    @DefaultValue(text="max-int")
    @Documentation(content="The number of bytes for a serialized message body so that any message that exceeds this limit will trigger message compression when the message is about to be sent across a SAF agent's JVM boundary.")
    public static final ValueProperty PROP_COMPRESSION_THRESHOLD = new ValueProperty(TYPE, "CompressionThreshold");
    @XmlBinding(path="reply-to-saf-remote-context-name")
    @Label(standard="reply-to remote SAF context")
    @Documentation(content="Specfiies the SAF Remote Context Name used by the replyTo destination in the remote cluster or server.")
    public static final ValueProperty PROP_REPLY_TO_REMOTE_SAF_CONTEXT = new ValueProperty(TYPE, "ReplyToRemoteSafContext");
    @Type(base=ISAFLoginContext.class)
    @XmlBinding(path="saf-login-context")
    @Label(standard="SAF login context")
    public static final ElementProperty PROP_SAF_LOGIN_CONTEXT = new ElementProperty(TYPE, "SafLoginContext");

    public Value<Integer> getCompressionThreshold();

    public void setCompressionThreshold(String var1);

    public void setCompressionThreshold(Integer var1);

    public Value<String> getReplyToRemoteSafContext();

    public void setReplyToRemoteSafContext(String var1);

    public ElementHandle<ISAFLoginContext> getSafLoginContext();
}

