/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms;

import oracle.eclipse.tools.weblogic.descriptors.jms.IMessageLoggingParams;
import oracle.eclipse.tools.weblogic.descriptors.jms.INamedEntity;
import oracle.eclipse.tools.weblogic.descriptors.jms.ISAFDestinationMember;
import oracle.eclipse.tools.weblogic.descriptors.jms.ISAFQueue;
import oracle.eclipse.tools.weblogic.descriptors.jms.ISAFTopic;
import oracle.eclipse.tools.weblogic.descriptors.jms.ITargetable;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.TargetingPolicyValidator;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.UniformDistributedDestinationDeploymentNameValidator;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.PossibleValues;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;

@Label(standard="SAF imported destinations")
public interface ISAFImportedDestinations
extends ISAFDestinationMember,
ITargetable,
INamedEntity,
IMessageLoggingParams {
    public static final ElementType TYPE = new ElementType(ISAFImportedDestinations.class);
    @Service(impl=TargetingPolicyValidator.class)
    public static final ValueProperty PROP_TARGETING_POLICY = new ValueProperty(TYPE, ITargetable.PROP_TARGETING_POLICY);
    @Service(impl=UniformDistributedDestinationDeploymentNameValidator.class)
    @Documentation(content="The subdeployment groups within this JMS module. Subdeployments enable you to deploy some resources in a JMS module to a JMS server and other JMS resources to a server instance or cluster.[pbr/]Standalone queues or topics can only be targeted to a single JMS server. Whereas, connection factories, uniform distributed destinations (UDDs), and foreign servers can be targeted to one or more JMS servers, one or more server instances, or to a cluster. Therefore, standalone queues or topics cannot be associated with a subdeployment if other members of the subdeployment are targeted to multiple JMS servers. However, UDDs can be associated with such subdeployments since the purpose of UDDs is to distribute its members to multiple JMS servers in a domain.")
    public static final ValueProperty PROP_SUB_DEPLOYMENT_NAME = new ValueProperty(TYPE, ITargetable.PROP_SUB_DEPLOYMENT_NAME);
    @Type(base=ISAFQueue.class)
    @Label(standard="SAF queue")
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="saf-queue", type=ISAFQueue.class)})
    public static final ListProperty PROP_SAF_QUEUES = new ListProperty(TYPE, "SafQueues");
    @Type(base=ISAFTopic.class)
    @Label(standard="SAF topic")
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="saf-topic", type=ISAFTopic.class)})
    public static final ListProperty PROP_SAF_TOPICS = new ListProperty(TYPE, "SafTopics");
    @XmlBinding(path="jndi-prefix")
    @Label(standard="JNDI prefix")
    @Documentation(content="Specifies the string that will prefix the local JNDI name of a remote destination.")
    public static final ValueProperty PROP_JNDI_PREFIX = new ValueProperty(TYPE, "JndiPrefix");
    @XmlBinding(path="saf-remote-context")
    @Label(standard="remote SAF context")
    @PossibleValues(property="/SAFRemoteContexts/Name")
    @Documentation(content="Specifies the remote context used for the imported destinations.")
    public static final ValueProperty PROP_SAF_REMOTE_CONTEXT = new ValueProperty(TYPE, "SafRemoteContext");

    public ElementList<ISAFQueue> getSafQueues();

    public ElementList<ISAFTopic> getSafTopics();

    public Value<String> getJndiPrefix();

    public void setJndiPrefix(String var1);

    public Value<String> getSafRemoteContext();

    public void setSafRemoteContext(String var1);
}

