/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms;

import oracle.eclipse.tools.weblogic.descriptors.jms.UnitOfOrderRouting;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.SAFErrorDestinationValuesValidator;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.PossibleValues;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface ISAFDestinationMember
extends Element {
    public static final ElementType TYPE = new ElementType(ISAFDestinationMember.class);
    @XmlBinding(path="saf-error-handling")
    @Label(standard="SAF error handling")
    @PossibleValues(property="/SAFErrorHandlers/Name")
    @Service(impl=SAFErrorDestinationValuesValidator.class)
    @Documentation(content="Specifies the error handling configuration used for the imported destinations.")
    public static final ValueProperty PROP_SAF_ERROR_HANDLING = new ValueProperty(TYPE, "SafErrorHandling");
    @Type(base=Long.class)
    @XmlBinding(path="time-to-live-default")
    @Label(standard="SAF default time-to-live (msecs)")
    @NumericRange(min="-1")
    @DefaultValue(text="0")
    @Documentation(content="Specifies the default Time-to-Live value (expiration time), in milliseconds, for imported JMS messages. The expiration time set on JMS messages will override this value unless the SAF Default Time-to-Live Enabled field is turned on, which then overrides the expiration time in JMS messages on imported destinations.")
    public static final ValueProperty PROP_TIME_TO_LIVE_DEFAULT = new ValueProperty(TYPE, "TimeToLiveDefault");
    @Type(base=Boolean.class)
    @XmlBinding(path="use-saf-time-to-live-default")
    @Label(standard="enable SAF default time-to-live")
    @DefaultValue(text="false")
    @Documentation(content="Controls whether the Time-to-Live (expiration time) value set on imported JMS messages will be overridden by the value specified in the SAF Default Time-to-Live field.")
    public static final ValueProperty PROP_SAF_DEFAULT_TIME_ENABLED = new ValueProperty(TYPE, "SafDefaultTimeEnabled");
    @Type(base=UnitOfOrderRouting.class)
    @XmlBinding(path="unit-of-order-routing")
    @Label(standard="message unit-of-order routing")
    @DefaultValue(text="Hash")
    @Documentation(content="Specifies the type of routing used to find a SAF agent when using the message unit of order feature.[ul][li]Hash: Indicates that message producers use the hash code of a message unit of order to find a SAF agent.[/li][li]PathService: Indicates that message producers use the Path Service to find a SAF agent.[/li][/ul]")
    public static final ValueProperty PROP_UNIT_OF_ORDER_ROUTING = new ValueProperty(TYPE, "UnitOfOrderRouting");

    public Value<String> getSafErrorHandling();

    public void setSafErrorHandling(String var1);

    public Value<Long> getTimeToLiveDefault();

    public void setTimeToLiveDefault(String var1);

    public void setTimeToLiveDefault(Long var1);

    public Value<Boolean> isSafDefaultTimeEnabled();

    public void setSafDefaultTimeEnabled(String var1);

    public void setSafDefaultTimeEnabled(Boolean var1);

    public Value<UnitOfOrderRouting> getUnitOfOrderRouting();

    public void setUnitOfOrderRouting(String var1);

    public void setUnitOfOrderRouting(UnitOfOrderRouting var1);
}

