/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms;

import oracle.eclipse.tools.weblogic.descriptors.jms.IMessageLoggingParams;
import oracle.eclipse.tools.weblogic.descriptors.jms.INamedEntity;
import oracle.eclipse.tools.weblogic.descriptors.jms.ISAFDestinationMember;
import oracle.eclipse.tools.weblogic.descriptors.jms.NonPersistentQos;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface ISAFDestination
extends ISAFDestinationMember,
INamedEntity,
IMessageLoggingParams {
    public static final ElementType TYPE = new ElementType(ISAFDestination.class);
    @XmlBinding(path="remote-jndi-name")
    @Label(standard="remote JNDI name")
    @Required
    @Documentation(content="The remote JNDI name of the remote destination.")
    public static final ValueProperty PROP_REMOTE_JNDI_NAME = new ValueProperty(TYPE, "RemoteJndiName");
    @XmlBinding(path="local-jndi-name")
    @Label(standard="local JNDI name")
    @Documentation(content="The local JNDI name of the remote destination.")
    public static final ValueProperty PROP_LOCAL_JNDI_NAME = new ValueProperty(TYPE, "LocalJndiName");
    @Type(base=NonPersistentQos.class)
    @XmlBinding(path="non-persistent-qos")
    @Label(standard="non-persistent quality of service")
    @DefaultValue(text="At-Least-Once")
    @Documentation(content="Specifies the quality of service for nonpersistent messages.[ul][li]Exactly-Once: Indicates that messages will be forwarded to the remote side once and only once except for any occurrence of server crashes.[/li][li]At-Least-Once: Indicates that messages will be forwarded to the remote side at least once. No message will be lost except for any occurrence of server crashes. However, messages may appear in the remote endpoint more than once.[/li][li]At-Most-Once: Indicates that messages will be forwarded to the remote side atmost once. No message will appear in the remote endpoint more than once. However, messages might be lost.[/li][/ul]")
    public static final ValueProperty PROP_NON_PERSISTENT_QOS = new ValueProperty(TYPE, "NonPersistentQos");

    public Value<String> getRemoteJndiName();

    public void setRemoteJndiName(String var1);

    public Value<String> getLocalJndiName();

    public void setLocalJndiName(String var1);

    public Value<NonPersistentQos> getNonPersistentQos();

    public void setNonPersistentQos(String var1);

    public void setNonPersistentQos(NonPersistentQos var1);
}

