/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms;

import oracle.eclipse.tools.weblogic.descriptors.jms.INamedEntity;
import oracle.eclipse.tools.weblogic.descriptors.jms.PolicyType;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

@Label(standard="quota")
public interface IQuota
extends INamedEntity {
    public static final ElementType TYPE = new ElementType(IQuota.class);
    @Type(base=Long.class)
    @NamedValues(arbitraryValueLabel="maximum bytes", defaultArbitraryValue="max-long", namedValues={@NamedValues.NamedValue(value="0", label="no messages can be placed on a destination without exceeding the quota"), @NamedValues.NamedValue(value="-1", label="no limit on messages")})
    @XmlBinding(path="bytes-maximum")
    @Label(standard="total number of bytes that can be stored in a destination")
    @NumericRange(min="-1")
    @DefaultValue(text="max-long")
    @Documentation(content="The total number of bytes that can be stored in a destination that uses this quota.")
    public static final ValueProperty PROP_MAXIMUM_BYTES = new ValueProperty(TYPE, "MaximumBytes");
    @Type(base=Long.class)
    @NamedValues(arbitraryValueLabel="maximum messages", defaultArbitraryValue="max-long", namedValues={@NamedValues.NamedValue(value="0", label="no messages can be placed on a destination without exceeding the quota"), @NamedValues.NamedValue(value="-1", label="no limit on messages")})
    @XmlBinding(path="messages-maximum")
    @Label(standard="number of messages that can be stored in a destination")
    @NumericRange(min="-1")
    @DefaultValue(text="max-long")
    @Documentation(content="The total number of messages that can be stored in a destination that uses this quota.")
    public static final ValueProperty PROP_MAXIMUM_MESSAGES = new ValueProperty(TYPE, "MaximumMessages");
    @Type(base=PolicyType.class)
    @XmlBinding(path="policy")
    @Label(standard="policy")
    @DefaultValue(text="FIFO")
    @Documentation(content="For destinations that use this quota, this policy determines whether or not to deliver smaller messages before larger ones when a destination has exceeded its message quota.[ul][li]FIFO: Indicates that requests for quota are submitted in the order they are received. If a given request for quota cannot be satisfied, and the client requesting the quota is willing to wait, then that request will block all other requests for quota until the request is satisfied or times out. This prevents smaller messages from being delivered when larger requests are already waiting for space.[/li][li]Preemptive: Indicates that subsequent requests can preempt previously unsatisfied requests. That is, if there is sufficient quota for the current request, then that space is used even if there are other requests waiting for quota. When quota is limited, the Preemptive policy can result in the starvation of larger requests.[/li][/ul]")
    public static final ValueProperty PROP_POLICY = new ValueProperty(TYPE, "Policy");
    @Type(base=Boolean.class)
    @XmlBinding(path="shared")
    @Label(standard="shared by multiple destinations")
    @DefaultValue(text="false")
    @Documentation(content="Indicates whether this quota is shared by multiple destinations that refer to it.[pbr/]If Shared is enabled (the default), all destinations referring to the quota object compete for resources the resources defined by that object. If one destination consumes a large number of messages or bytes, then this will prevent other destinations from obtaining quota.[pbr/]If Shared is disabled, the quota object behaves as a template. Each destination referring to the quota object gets its own internal instance of the object for tracking quota.[pbr/]Destinations within the same JMS module may share quotas in any way they want. However, quota sharing only takes place for destinations within the same JMS server. In other words, if destinations X and Y both share the same quota Q, and the quota Q has Shared enabled, then X and Y will only share quota if both are deployed to the same JMS server.")
    public static final ValueProperty PROP_SHARED = new ValueProperty(TYPE, "Shared");

    public Value<Long> getMaximumBytes();

    public void setMaximumBytes(String var1);

    public void setMaximumBytes(Long var1);

    public Value<Long> getMaximumMessages();

    public void setMaximumMessages(String var1);

    public void setMaximumMessages(Long var1);

    public Value<PolicyType> getPolicy();

    public void setPolicy(String var1);

    public void setPolicy(PolicyType var1);

    public Value<Boolean> isShared();

    public void setShared(String var1);

    public void setShared(Boolean var1);
}

